/***************************************************************************************
* File name    :	RSA.h
* Function     :	The header of RSA.c
* Author       : 	Hongjz
* Date         :	2015/09/15
* Version      :    v1.0
* Description  :    
* ModifyRecord :
*****************************************************************************************/
#ifndef _SYRSA_H_
#define _SYRSA_H_ 

/***************************************************************************
* Include Header Files
***************************************************************************/


/**************************************************************************
* Global Macro Definition
***************************************************************************/
#define  RSAPublicEncrypt  RSA_PublicEncrypt
#define  RSAPublicDecrypt  RSA_PublicDecrypt
#define  RSAPrivateEncrypt RSA_PrivateEncrypt
#define  RSAPrivateDecrypt RSA_PrivateDecrypt
/**************************************************************************
* Global Type Definition
***************************************************************************/

typedef enum 
{
	RSA_Success = 0,
	RSA_PARA_Err,		//
	RSA_OTHER_Err,		//

}RSA_RT;

/* RSA prototype key. */
typedef struct{
	UINT32 bits;                // length in bits of modulus 
	UINT32 PublicExponent;      // public exponent 
}R_RSA_PROTO_KEY;
	
/* RSA public key. */	
	
typedef struct{
	UINT16 bits;				// length in bits of modulus
	UINT8* modulus;				// modules ൱n
	UINT8* exponent;            // public exponent ൱e 
}R_RSA_PUBLIC_KEY;

/* RSA private key. */	
typedef struct{
	UINT16 bits;               // length in bits of modulus
	UINT8* modulus;            // modulus   ൱n
	UINT8* publicExponent;     // public exponent  ൱e
	UINT8* exponent;           // private exponent ൱d,CRTģʽ㣬˲ԴNULL,Խʡջռ.
	UINT8* prime[2];           // prime factors   ൱p,q
	UINT8* primeExponent[2];   // exponents for CRT ൱dP,dQ
	UINT8* coefficient;        // CRT coefficient  ൱qInv
	UINT8* dmodulus;           // dn
}R_RSA_PRIVATE_KEY,R_RSA_KEYPAIR;
/**************************************************************************
* Global Variable Declaration
***************************************************************************/

/**************************************************************************
* Global Functon Declaration
***************************************************************************/

/*********************************************************************************************************
ԭͣ	UINT8 RSA_GenKeyPair(R_RSA_PROTO_KEY protoKey,R_RSA_PRIVATE_KEY *privateKey)
˵	RSAԿԣݱ
˵	protoKey [I] --- ʱĲ
							1024λԿʱprotoKey->bits=1024
							2048λԿʱprotoKey->bits=2048
							protoKey ->PublicExponentһΪ365537ֵŵӦRSAԿԽṹеpublicExponentУpRSAKeypublicExponentĴŸʽΪpublicExponent[0]Ϊֽڡ 
			pRSAKey [O] --- Կ
ֵ	0ɹֵʧ
ע	pRSAKeyṹָָ飬ַֽڶ
********************************************************************************************************/
extern	UINT8 RSA_GenKeyPair(R_RSA_PROTO_KEY protoKey,R_RSA_PRIVATE_KEY *privateKey);

/*********************************************************************************************************
ԭͣ	UINT8 RSA_PubKeyOpt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PUBLIC_KEY *publicKey)
˵	Կ
˵	output [O] --- 
			outputLen [O] --- ȣΪprotoKey->bits/8ֽڣ
			input [I] --- ݣ
			InputLen [I] --- ݳȣΪprotoKey->bits/8ֽڣ
			RSAKey [I] --- ԿʵֻõR_RSA_PRIVATE_KEYеpublicExponentmodulus飬Ϊ
ֵ	0ɹֵʧ
ע	˺ûжݽPaddingҪԼPadding˲ԶݽйԿܻ߶˽Կܵݽнܡ
			֧ʹͬһݻҪݵַ4ֽڶ
********************************************************************************************************/
extern	UINT8 RSA_PubKeyOpt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PUBLIC_KEY *publicKey);

/*********************************************************************************************************
ԭͣ	UINT8 RSA_PriKeyOpt_NoCRT(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PRIVATE_KEY *privateKey)
˵	˽Կ
˵	output [O] --- 
			outputLen [O] --- ȣΪprotoKey->bits/8ֽڣ
			input [I] --- ݣ
			inputLen [I] --- ݳȣΪprotoKey->bits/8ֽڣ
			privateKey [I] --- ˽Կʹ˽ṹеmodulusexponent
ֵ	0ɹֵʧ
ע	˺ûжݽPaddingҪԼPadding˲Զݽ˽Կܣ߶ԹԿܵݽнܡ
********************************************************************************************************/ 
extern	UINT8 RSA_PriKeyOpt_NoCRT(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PRIVATE_KEY *privateKey);

/*********************************************************************************************************
ԭͣ	UINT8 RSA_PriKeyOpt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PRIVATE_KEY *privateKey)
˵	˽Կ
˵	output [O] --- 
			outputLen [O] --- ȣΪprotoKey->bits/8ֽڣ
			input [I] --- ݣ
			inputLen [I] --- ݳȣΪprotoKey->bits/8ֽڣ
			privateKey [I] --- ˽Կ˽Կʹ˽ṹеprime[0]prime[1]modulusprimeExponent[0]primeExponent[1]coefficient
ֵ	0ɹֵʧ
ע	˺ûжݽPaddingҪԼPadding˲Զݽ˽Կܣ߶ԹԿܵݽнܡ			
********************************************************************************************************/  
extern	UINT8 RSA_PriKeyOpt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PRIVATE_KEY *privateKey);

/*********************************************************************************************************
ԭͣ	UINT8 RSA_PublicEncrypt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PUBLIC_KEY *publicKey)
˵	Կ
˵	output [O] --- 
			outputLen [O] --- ȣΪprotoKey->bits/8ֽڣ
			input[I] --- ݣ
			inputLen [I] --- ݳȣPKCS#1СprotoKey->bits/8 - 11ֽڣ
			publicKey [I] --- ԿʵֻõR_RSA_PRIVATE_KEYеpublicExponentmodulus
ֵ	0ɹֵʧ
ע	˺ԼݰPKCS#1Padding֧ʹͬһݻҪݵַ4ֽڶ롣
********************************************************************************************************/
extern	UINT8 RSA_PublicEncrypt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PUBLIC_KEY *publicKey);
/*********************************************************************************************************
ԭͣ	UINT8 RSA_PublicDecrypt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PUBLIC_KEY *publicKey)
˵	Կ
˵	output [O] --- 
			outputLen [O] --- ȣСprotoKey->bits/8 - 11ֽڣ
			input [I] --- ݣ
			inputLen [I] --- ݳȣΪprotoKey->bits/8ֽڣ
			publicKey [I] --- ԿʵֻõR_RSA_PRIVATE_KEYеpublicExponentmodulus
ֵ	0ɹֵʧ
ע	˺ԽܵݰPKCS#1ʽнصǽõݡ֧ʹͬһݻҪݵַ4ֽڶ롣
********************************************************************************************************/
extern	UINT8 RSA_PublicDecrypt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PUBLIC_KEY *publicKey);
/*********************************************************************************************************
ԭͣ	UINT8 RSA_PrivateEncrypt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PRIVATE_KEY *privateKey)
˵	˽Կ
˵	output [O] --- 
			outputLen [O] --- ȣΪprotoKey->bits/8ֽڣ
			input [I] --- ݣ
			inputLen [I] --- ݳȣPKCS#1СprotoKey->bits/8 - 11ֽڣ
			privateKey [I] --- ˽Կ˽Կʹ˽ṹеprime[0]prime[1]modulusprimeExponent[0]primeExponent[1]coefficient
ֵ	0ɹֵʧ
ע	˺ԼݰPKCS#1Padding֧ʹͬһݻҪݵַ4ֽڶ롣
********************************************************************************************************/
extern	UINT8 RSA_PrivateEncrypt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PRIVATE_KEY *privateKey);
/*********************************************************************************************************
ԭͣ	UINT8 RSA_PrivateDecrypt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PRIVATE_KEY *privateKey)
˵	˽Կ
˵	output [O] --- 
			outputLen [O] --- ȣСprotoKey->bits/8 - 11ֽڣ
			input [I] --- ݣ
			inputLen [I] --- ݳȣΪprotoKey->bits/8ֽڣ
			privateKey [I] --- ˽Կ˽Կʹ˽ṹеprime[0]prime[1]modulusprimeExponent[0]primeExponent[1]coefficient
ֵ	0ɹֵʧ
ע	˺ԽܵݰPKCS#1ʽнصǽõݡ֧ʹͬһݻҪݵַ4ֽڶ롣
********************************************************************************************************/ 
extern	UINT8 RSA_PrivateDecrypt(UINT8 *output,UINT32 *outputLen,UINT8 *input,UINT32 inputLen,R_RSA_PRIVATE_KEY *privateKey);
/*********************************************************************************************************
ԭͣ	UINT8 RSA_Check(void)
˵	RSAԼ
˵	
ֵ	0ɹֵʧ
ע	ʹһ̶ݼģ
********************************************************************************************************/ 
extern	UINT8 RSA_Check(void);
/*********************************************************************************************************
ԭͣ	void RsaVersion(INT8 data[12])
˵	Rsa㷨汾Żȡ
˵	INT8 data [O] -- 㷨汾			
ֵ	
ע	
********************************************************************************************************/ 
extern	void RsaVersion(INT8 data[12]);
#endif
