/***************************************************************************************
* File name    :	SM1.h
* Function     :	The header of SM1.c
* Author       : 	Hongjz
* Date         :	2015/09/15
* Version      :    v1.0
* Description  :    
* ModifyRecord :
*****************************************************************************************/
#ifndef _SM1_H_
#define _SM1_H_

/***************************************************************************
* Include Header Files
***************************************************************************/


/**************************************************************************
* Global Macro Definition
***************************************************************************/
#define SM1_ENCRYPT 1
#define SM1_DECRYPT 2
#define SM1_CBC 1
#define SM1_ECB 2
#define SM1_CFB 3
#define SM1_OFB 4

/**************************************************************************
* Global Type Definition
***************************************************************************/
typedef enum 
{
	SM1_Success = 0, 
	SM1_Err,
}SM1_RT;
/**************************************************************************
* Global Variable Declaration
***************************************************************************/

/**************************************************************************
* Global Functon Declaration
***************************************************************************/

/*********************************************************************************************************
ԭͣ	UINT8 SM1_Init(UINT8* pEK,UINT8* pAK)
˵	SM1 Կʼ
˵	UINT8* pEK [I] -- 16ֽ
			UINT8* pAK [I] -- 16ֽ			
ֵ	0ɹֵʧ
ע
********************************************************************************************************/
extern	UINT8 SM1_Init(UINT8* pEK,UINT8* pAK);

/*********************************************************************************************************
ԭͣ	UINT8 _SM1_Run(UINT8 nType,UINT32 nAddr,UINT16 nDataLen)
˵	SM1Ӳ
˵	UINT8  nType [I] -- SM1_ENCRYPT/SM1_DECRYPT
			UINT32 nAddr [I] -- ׵ַҲ׵ַÿռΪ0x20020000~0x20020800
			UINT16 nDataLen [I] -- ݳȣΪ16ıPadding
ֵ	0ɹֵʧ
ע	úֻECBģʽ㣬úֱӵ㷨ҪûݷŵnAddrַnAddrַȡ
********************************************************************************************************/
extern	UINT8 _SM1_Run(UINT8 nType,UINT32 nAddr,UINT16 nDataLen);

/*********************************************************************************************************
ԭͣ	UINT8 SM1_Run_ECB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen)
˵	SM1 ECBģʽӽ
˵	UINT8  nType [I] -- SM1_ENCRYPT/SM1_DECRYPT
			UINT8* pIn [I] --
			UINT8* pOut [O] --
			UINT16 nDataLen [I] -- ݳȣΪ16ıPaddingСڵ1024
ֵ	0ɹֵʧ
ע	
********************************************************************************************************/
extern	UINT8 SM1_Run_ECB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen);

/*********************************************************************************************************
ԭͣ	UINT8 SM1_Run_CBC(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV)
˵	SM1 CBCģʽӽ
˵	UINT8  nType [I] -- SM1_ENCRYPT/SM1_DECRYPT
			UINT8* pIn [I] --
			UINT8* pOut [O] --
			UINT16 nDataLen [I] -- ݳȣΪ16ıPadding
			UINT8* pIV [I/O] --  IVصIVֵڸģʽ´㣬Ϊ16ֽ
ֵ	0ɹֵʧ
ע	ΪIV壬ͬʱҪշصIVҪԭʼIVʱҪԭʼIV
********************************************************************************************************/
extern	UINT8 SM1_Run_CBC(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV);

/*********************************************************************************************************
ԭͣ	UINT8 SM1_Run_CFB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV)
˵	SM1 CFBģʽӽ
˵	UINT8  nType [I] -- SM1_ENCRYPT/SM1_DECRYPT
			UINT8* pIn [I] --
			UINT8* pOut [O] --
			UINT16 nDataLen [I] -- ݳȣΪ16ıPadding
			UINT8* pIV [I/O] --  IVصIVֵڸģʽ´㣬Ϊ16ֽ
ֵ	0ɹֵʧ
ע	ΪIV壬ͬʱҪշصIVҪԭʼIVʱҪԭʼIV
********************************************************************************************************/
extern	UINT8 SM1_Run_CFB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV);

/*********************************************************************************************************
ԭͣ	UINT8 SM1_Run_OFB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV)
˵	SM1 OFBģʽӽ
˵	UINT8  nType [I] -- SM1_ENCRYPT/SM1_DECRYPT
			UINT8* pIn [I] --
			UINT8* pOut [O] --
			UINT16 nDataLen [I] -- ݳȣΪ16ıPadding
			UINT8* pIV [I/O] --  IVصIVֵڸģʽ´㣬Ϊ16ֽ
ֵ	0ɹֵʧ
ע	ΪIV壬ͬʱҪշصIVҪԭʼIVʱҪԭʼIV
********************************************************************************************************/
extern	UINT8 SM1_Run_OFB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV);

/*********************************************************************************************************
ԭͣ	UINT8 SM1_Run(UINT8 nType,UINT8 nMode,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV)
˵	SM1ӽ㡢֧CBCECBCFBOFBģʽ
˵	UINT8  nType [I] -- SM1_ENCRYPT/SM1_DECRYPT
			UINT8  nMode [I] -- SM1_CBC/SM1_ECB/SM1_CFB/SM1_OFB
			UINT8* pIn [I] --
			UINT8* pOut [O] --
			UINT16 nDataLen [I] -- ݳȣΪ16ıPadding
			UINT8* pIV [I/O] --  IVIVֵ´㣬Ϊ16ֽڡΪECBģʽʱֵӦΪNULL
ֵ	0ɹֵʧ
ע	ΪIV壬ͬʱҪշصIVҪԭʼIVʱҪԭʼIV
********************************************************************************************************/
extern	UINT8 SM1_Run(UINT8 nType,UINT8 nMode,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV);


/*********************************************************************************************************
ԭͣ	void Sm1Version(INT8 data[12])
˵	SM1㷨汾Żȡ
˵	INT8 data [O] -- 㷨汾			
ֵ	
ע	
********************************************************************************************************/ 
extern	void Sm1Version(INT8 data[12]);

#endif
