/***************************************************************************************************
**  File name    : Protocol.c
**  Function     : ͨѶЭ 
**  Author       : yangf
**  Date         : 2013/12/17
**  Version      : v1.0
**  ModifyRecord :
***************************************************************************************************/
/***************************************************************************************************
** Include Header Files
***************************************************************************************************/
#include "SYglobal.h"
//#include "Protocol.h"
#include "UartProtocol.h"
#include "UsbProtocolX.h"
/***************************************************************************************************
** Local Macro Definition
***************************************************************************************************/


/***************************************************************************************************
** Local Type Definition
***************************************************************************************************/

/***************************************************************************************************
** Local static Variable Declaration
***************************************************************************************************/

/***************************************************************************************************
** Global Variable Declaration
***************************************************************************************************/

COMM_HANDLE gsCommHandle;

#ifdef USE_I2C
	STRUCT_I2C_FORMAT I2C_Frame;
	STRUCT_DATA_BUF RxBuf, TxBuf;
	UINT8 RxArr[50], TxArr[50];
#endif

/***************************************************************************************************
** Local Functon Declaration
***************************************************************************************************/

/***************************************************************************************************
** Functon
***************************************************************************************************/


/***************************************************************************************************
** Subroutine  : ProtocolInit
** Function    : ͨѶʼ 
** Input       :  
** Output      : 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/


#ifdef USE_I2C_A12_A13
void I2C_init()
{
	I2C_Init(I2C0, I2C0_MAP_A12_A13, I2C_Frame,&RxBuf, &TxBuf);  

}
#endif 
#ifdef USE_I2C_A16_A17
void I2C_init()
{
	I2C_Init(I2C0, I2C0_MAP_A16_A17, I2C_Frame,&RxBuf, &TxBuf);


}

#endif

void ProtocolInit(void)
{
    gsCommHandle.pInsBuf=(UINT8 *)(COMM_INS_BUF);
	gsCommHandle.pParaBuf=(UINT8 *)(COMM_INS_PARA_BUF);
	gsCommHandle.pDatBuf=(UINT8 *)(COMM_DATA_BUF);
	gsCommHandle.pImgBuf=(UINT8 *)(COMM_IMG_BUF);
	
	gsCommHandle.dwPktSize=gsCommHandle.dwPktSize;
	//gsCommHandle.dwCommPsd=0;  			//should set at initial system parameter  
	gsCommHandle.cPwdVfyFg=0;
	gsCommHandle.cInitItrfce=0;
	
    
    gsCommHandle.stComInterFace.stPkgRec.cPkgTy=COMM_INS;
	gsCommHandle.stComInterFace.stPkgRec.cInterfaceTy=NO_COMM_WORK;
	gsCommHandle.stComInterFace.stPkgRec.pInsBuf=gsCommHandle.pInsBuf;
	gsCommHandle.stComInterFace.stPkgRec.pDtBuf=gsCommHandle.pDatBuf;
	gsCommHandle.stComInterFace.stPkgRec.wPkgLen=0;
	gsCommHandle.stComInterFace.stPkgRec.dwDtLen=0;
	gsCommHandle.stComInterFace.stPkgRec.dwDataOffset=0;
	
	gsCommHandle.stComInterFace.stPkgSend.cPkgTy=COMM_INS;
	gsCommHandle.stComInterFace.stPkgSend.cInterfaceTy=NO_COMM_WORK;
	gsCommHandle.stComInterFace.stPkgSend.pInsBuf=gsCommHandle.pInsBuf;
	gsCommHandle.stComInterFace.stPkgSend.wPkgLen=0;
	gsCommHandle.stComInterFace.stPkgSend.pDtBuf=gsCommHandle.pDatBuf;
	gsCommHandle.stComInterFace.stPkgSend.dwDtLen=0;
	gsCommHandle.stComInterFace.stPkgSend.dwDataOffset=0;
	
	gsCommHandle.stComApp.stInApp.pPkg=gsCommHandle.stComInterFace.stPkgRec.pInsBuf;
	gsCommHandle.stComApp.stOutApp.cDatStus=COMM_INS;
	gsCommHandle.stComApp.stOutApp.pata=gsCommHandle.pParaBuf;
	gsCommHandle.stComApp.stOutApp.pcDat=gsCommHandle.pDatBuf;
	gsCommHandle.stComApp.stOutApp.cpataLen=0;
	gsCommHandle.stComApp.stOutApp.dwDatLen=0;
	gsCommHandle.stComApp.stOutApp.dwDataOffset=0;

#ifdef USE_USB	
	USBProtocolInit(&gsCommHandle.stComInterFace);
#endif	
	 
#ifdef USE_UART	
    UartProtocolInit(&gsCommHandle.stComInterFace,gParaTab.CFG_BaudRate );// 6
#endif	


#ifdef USE_I2C_A12_A13

	I2C_Frame.bMasterEn = SLAVE; //slave mode
	I2C_Frame.bAddrBits = 7;
	I2C_Frame.bSlaveAddr = 0x25;
//	I2C_Frame.bSlaveAddr = 0x30;   // 
	RxBuf.pBuf = RxArr;
	RxBuf.Size = sizeof(RxArr);
	TxBuf.pBuf = TxArr;
	TxBuf.Size = sizeof(TxArr); 	
	I2C_Init(I2C0, I2C0_MAP_A12_A13, I2C_Frame,&RxBuf, &TxBuf); 
	
	
#endif

#ifdef  USE_I2C_A16_A17	
	

	I2C_Frame.bMasterEn = SLAVE; //slave mode
	I2C_Frame.bAddrBits = 7;
	I2C_Frame.bSlaveAddr = 0x25;
	RxBuf.pBuf = RxArr;
	RxBuf.Size = sizeof(RxArr);
	TxBuf.pBuf = TxArr;
	TxBuf.Size = sizeof(TxArr);
 	I2C_Init(I2C0, I2C0_MAP_A16_A17, I2C_Frame,&RxBuf, &TxBuf);

#endif
}

/***************************************************************************************************
** Subroutine  : CmdChkCom
** Function    : CRCУ 
** Input       : UINT8 *cpRecBuf --  ݰָ 
** Output      : ɹ:RT_OK,ʧ:RT_FAIL
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
BOOL CmdChkCom(UINT8 *cpRecBuf)
{
	
	UINT16 nwPKLen,nwRecCHK,nwGenCHK;
	
	BW(cpRecBuf[7],cpRecBuf[8],nwPKLen);
	BW(cpRecBuf[7+nwPKLen],cpRecBuf[8+nwPKLen],nwRecCHK);
	
	nwGenCHK = CmdGenCHK(cpRecBuf);
	
	if(nwGenCHK != nwRecCHK)
		return RT_FAIL;
	else
		return RT_OK;
}

/***************************************************************************************************
** Subroutine  : CmdGenCHK
** Function    : CRCУ 
** Input       : UINT8 *cpRecBuf --  У 
** Output      : ֵ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT16 CmdGenCHK(UINT8 *cpRecBuf)
{
	UINT16 wLen;
	UINT32 i;
	UINT16 nwCHK = 0;
	
	wLen = cpRecBuf[7] * 256 + cpRecBuf[8];

	for(i = 6; i < 7+wLen;i++)
		nwCHK += (cpRecBuf[i]&0xff);
		
	cpRecBuf[7+wLen] = nwCHK/256;
	cpRecBuf[8+wLen] = nwCHK%256;

	return(nwCHK);
}


/***************************************************************************************************
** Subroutine  : PkgVfy
** Function    : ЭЧ֤ 
** Input       : UINT8 *pCbuf --  Эָ 
** Output      : ַ:PS_DEVICE_ADDR_ERR, CRC:PS_COMM_ERR,Ч:PS_OK
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 PkgVfy(UINT8 *pCbuf)
{
    UINT32 dwDeviceAddr,dwPkgAddr;

    dwPkgAddr=(pCbuf[2] << 8) + pCbuf[3] ;
    dwPkgAddr= (dwPkgAddr << 16) + (pCbuf[4] << 8) + pCbuf[5];
    
	dwDeviceAddr = ((UINT32)(gParaTab.DeviceAddr[0] & 0xffff) << 16) + (gParaTab.DeviceAddr[1] & 0xffff) ;
	
	
	if(dwPkgAddr != dwDeviceAddr)    //ַ֤ 
	{
        return PS_DEVICE_ADDR_ERR;	
    }
    
    if(CmdChkCom(pCbuf)==RT_FAIL)        //жУ УΪ RT_FAIL 
    {
        return PS_COMM_ERR;	
    }
 	return PS_OK; 
}

/***************************************************************************************************
** Subroutine  : MakePackageHead
** Function    : Эİͷ 
** Input       : UINT8 *pHead --  ɵİͷָ 
**             : UINT8 nType  --  ʾ 
**             : UINT8 wLen   --   
** Output      : 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void MakePackageHead(UINT8* pHead,UINT8 nType,UINT32 wLen)
{ 	
	pHead[0] = 0xef;
	pHead[1] = 0x01;
	pHead[2] = (gParaTab.DeviceAddr[0] >> 8) & 0xff;
	pHead[3] = gParaTab.DeviceAddr[0] & 0xff;
	pHead[4] = (gParaTab.DeviceAddr[1] >> 8) & 0xff;
	pHead[5] = gParaTab.DeviceAddr[1] & 0xff;
	pHead[6] = nType;
	pHead[7] = ((wLen+2) >> 8) & 0xff;        
	pHead[8] = (wLen+2) & 0xff;
}

/***************************************************************************************************
** Subroutine  : MakePackage/MakePackageCpt 
** Function    : Э 
** Input       : UINT8 *pIn  --   ݡַ 
**             : UINT8 *pOut --   ָ 
**             : UINT8 nType  --  ʾ 
**             : UINT8 wLen   --  ݳ 
** Output      :  
** Description : MakePackageCpt:ֽڴ ;MakePackage:ȫֽڴ 
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT32 MakePackage(UINT8 *pIn,UINT8 *pOut,UINT32 wLen,UINT8 nType)
{
    UINT32 i;

    MakePackageHead(pOut,nType,wLen);//ͷ 
    for(i = 0; i < wLen; i++)      
	{
		pOut[COMM_PAKGE_LEN+i] = pIn[i];
	}
	CmdGenCHK(pOut);
	return COMM_PAKGE_LEN+wLen+2;
}
/* ͼݰ  ֽڴ*/ 
UINT32 MakePackageCpt(UINT8 *pIn,UINT8 *pOut,UINT32 wLen,UINT8 nType)
{
    UINT32 i;
    UINT8 cVal; 
    MakePackageHead(pOut,nType,wLen/2);//ͷ 
    for(i = 0; i < wLen;i++)      
	{
        cVal = ((pIn[2*i+1]>>4) & 0x0f);		//translate the high 4 bits of one byte              
		cVal |=  (pIn[2*i]&0xf0);
		pOut[COMM_PAKGE_LEN+i] =cVal;
	}
	CmdGenCHK(pOut);
	return COMM_PAKGE_LEN+wLen/2+2;
}
/***************************************************************************************************
** Subroutine  : GetDatFrompkg/GetDatFrompkgCpt
** Function    : Чݰлȡ 
** Input       : UINT8 *pIn   --  ݰָ   
**             : UINT8 *pOut  --  ȡָ 
**             : UINT8 *pwLen --  ȡݳ 
** Output      : PS_DEVICE_ADDR_ERR, PS_COMM_ERR,PS_OK
** Description : GetDatFrompkg:ȫֽڴݰ ; GetDatFrompkgCptڰֽڴݰ 
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void GetDatFrompkg(UINT8 *pIn,UINT8 *pOut,UINT32 *pwLen)
{
    UINT32 dwLen,i;
    
    dwLen=0;
    dwLen=(((UINT16)pIn[7] & 0xff) << 8) + (pIn[8] & 0xff) - 2;
    
    for(i = 0; i < dwLen; i++)      
	{
		pOut[i] = pIn[COMM_PAKGE_LEN+i];
	}
	*pwLen=dwLen;
}
/* ͼݰ  ֽڴ*/ 
void GetDatFrompkgCpt(UINT8 *pIn,UINT8 *pOut,UINT32 *pwLen)
{
    UINT32 i;
    UINT8 cVal;
    UINT32 dwLen;
     
    dwLen=0;
    dwLen=(((UINT16)pIn[7] & 0xff) << 8) + (pIn[8] & 0xff) - 2;
    
    for(i = 0; i < dwLen;i++)      
	{
        cVal=pIn[COMM_PAKGE_LEN+i];
    	pOut[i*2] =(cVal & 0xf0);
    	pOut[i*2+1]= (cVal & 0x0f)<<4 ;
	}
    *pwLen=dwLen*2;
}

/***************************************************************************************************
** Subroutine  : PackageSend
** Function    : ݰ 
** Input       : PKG_SEND *psSendPkg --  Э 
** Output      : 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void PackageDatSend(PKG_SEND *psSendPkg)
{
    switch (psSendPkg->cInterfaceTy)
    {
    	case COMM_UART:
#ifdef USE_UART
            UartPkgDatSend(psSendPkg,gsCommHandle.dwPktSize);
#endif
			break;
			
        case COMM_USB:
            UsbPkgDat(psSendPkg);
            break;		
			
#ifdef USE_I2C						
		case COMM_I2C:
			/* Only send response!!  Send data and img are not implement yet! */
			I2C_SlaveWriteBuf(I2C0, psSendPkg->pInsBuf, psSendPkg->wPkgLen); 
			
			break;
#endif
		default:	break;         
      
    }    
}
/***************************************************************************************************
** Subroutine  : DoAppOut
** Function    : Ӧòָ 
** Input       : PKG_OUT_APP *psSendPkg --  ָ 
** Output      : 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void DoAppOut(PKG_OUT_APP *p)
{
    PKG_SEND *psSendPkg;
    PKG_RECVICE *psPkgRec;
    
    psPkgRec=&gsCommHandle.stComInterFace.stPkgRec;
    psSendPkg=&gsCommHandle.stComInterFace.stPkgSend;
    
    // Ӧָ 
    psSendPkg->cInterfaceTy=psPkgRec->cInterfaceTy;
    psPkgRec->cInterfaceTy=NO_COMM_WORK;
    
    psSendPkg->wPkgLen=MakePackage(p->pata,psSendPkg->pInsBuf,p->cpataLen,0x07);

    switch (p->cDatStus)
    {
    	case COMM_INS:
            psSendPkg->cPkgTy=COMM_INS;
            break;
        case COMM_DATA_REC:
            psPkgRec->cPkgTy=COMM_DATA_REC;
            psPkgRec->pDtBuf = p->pcDat;
            psPkgRec->dwDtLen = p->dwDatLen;
            psPkgRec->dwDataOffset=0;
            break;
        case COMM_DATA_SEND:
            psSendPkg->cPkgTy=COMM_DATA_SEND;
            psSendPkg->pDtBuf=p->pcDat;
            psSendPkg->dwDtLen=p->dwDatLen;
            psSendPkg->dwDataOffset=0;
            break;
        case COMM_IMG_REC:
            psPkgRec->cPkgTy=COMM_IMG_REC;
            psPkgRec->pDtBuf = p->pcDat;
            psPkgRec->dwDtLen = p->dwDatLen;
            psPkgRec->dwDataOffset=0;
            break;
        case COMM_IMG_SEND:
            psSendPkg->cPkgTy=COMM_IMG_SEND;
            psSendPkg->pDtBuf=p->pcDat;
            psSendPkg->dwDtLen=p->dwDatLen;
            psSendPkg->dwDataOffset=0;
            break;
        default:
            break;
        
    }
    
    PackageDatSend(psSendPkg);  
    
}

/***************************************************************************************************
** Subroutine  : PackageDatRec
** Function    : ݰ 
** Input       : PKG_RECVICE *p -- Э 
** Output      : յݳ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT32 PackageDatRec(PKG_RECVICE *p)
{
    UINT32 dwLen;
    dwLen=0;
    switch (p->cInterfaceTy)
    {
    	case COMM_UART:
#ifdef USE_UART
            dwLen=UartPkgDatRec(p);
#endif
            break;
        case COMM_USB:
 //           USB_PkgSend();
//            UsbPkgRec();
            break;
    }    
    return dwLen;
}

#ifdef USE_I2C    
void I2C_GetPackage(PKG_RECVICE *p)
{
	UINT16 ValidLen = I2C_GetRxFIFOValidSize(I2C0), ValidLenNew;
	UINT32 nwPKOFCMDLen;
	UINT8 *pRec;
	UINT16 timeout = 0, timeout2;
	volatile struct USART_REGS *pI2c = &I2C0Regs;	// get usart registers address;

	if (ValidLen == 0)//COMM_PAKGE_LEN)   
	   return;

	NVIC_DisableIRQ(USB_IRQn);

    timeout = 60000;
    ValidLenNew = ValidLen;
    while(ValidLen == ValidLenNew)// && ValidLen < COMM_PAKGE_LEN)
    {
        ValidLenNew = I2C_GetRxFIFOValidSize(I2C0);
		if(!--timeout)
            break;
            
		_delay_us(10);
    }
    
    ValidLen = ValidLenNew;
	if (ValidLen < COMM_PAKGE_LEN && !timeout)    //??????? ??+????+???+???
	{
        //pI2c->GCTL.bit.RxEn = 0;
        //pI2c->GCTL.bit.TxEn = 0;
        I2C_InitRxFIFO(I2C0, &RxBuf);
        goto exit_0;
    }
       
    timeout = 60000;
	pRec = p->pInsBuf;
	memset(pRec, 0, COMM_PAKGE_LEN); //??+????+???+??? ??0 
	while(I2C_SlaveReadBuf(I2C0, &pRec[0], COMM_PAKGE_LEN) != RT_OK)
	{
		if(!--timeout)
			goto exit_0;
		_delay_us(10);
	}
	
	nwPKOFCMDLen = (pRec[7] << 8) + pRec[8];
	if(nwPKOFCMDLen > (gsCommHandle.dwPktSize+2))
		goto exit_0;

	timeout = 60000;
	while(I2C_SlaveReadBuf(I2C0, &pRec[COMM_PAKGE_LEN], nwPKOFCMDLen) != RT_OK)
	{
		if(!--timeout)
			goto exit_0;           
		_delay_us(10);
	}

	p->wPkgLen=nwPKOFCMDLen+COMM_PAKGE_LEN;
	p->cInterfaceTy=COMM_I2C;      
    
exit_0:
	NVIC_EnableIRQ(USB_IRQn);
    
}
#endif
/***************************************************************************************************
** Subroutine  : Get_Pkg
** Function    : Э 
** Output      :  
** Description : Э  
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void Get_Pkg(void)
{
#ifdef USE_UART           
 	UART_GetPackage(&gsCommHandle.stComInterFace.stPkgRec);
#endif
		
#ifdef USE_USB	
    USB_GetPkg(); 
#endif

#ifdef USE_I2C 
	I2C_GetPackage(&gsCommHandle.stComInterFace.stPkgRec);
#endif

	
}
/***************************************************************************************************
** Subroutine  : DoCommPkg
** Function    : Э 
** Input       :  
** Output      : 
** Description : 
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 DoCommPkg(void)
{
	UINT8 cRet,*pIns;
    PKG_OUT_APP *psOutApp; 
    PKG_RECVICE *psPkgRec;
    
    psPkgRec = &gsCommHandle.stComInterFace.stPkgRec;
     psOutApp = &gsCommHandle.stComApp.stOutApp; 

    if (psPkgRec->cInterfaceTy == NO_COMM_WORK)
	{
        if(flagCmd != 0)//δɵ
		{
			psPkgRec->cInterfaceTy = whichCom;
			goto LABCMD;
		}	
		return RT_FAIL;
	}
    
	pIns=psPkgRec->pInsBuf;
    cRet=PkgVfy(pIns);
    _nop();
    if (cRet!=PS_OK)//ַ 
    {
        psOutApp->cDatStus=COMM_INS;
        psOutApp->cACK=cRet;
        psOutApp->pata[0]=cRet;
        psOutApp->cpataLen=1;
        psOutApp->cDoStatus=DO_WAIT;
	    goto LABEXIT;
    } 
     //+ûнУ+Уָ
    if ((gsCommHandle.dwCommPsd!=0) &&(gsCommHandle.cPwdVfyFg!=1) && (pIns[9]!=PS_VfyPwd))  
    {
    	psOutApp->cDatStus=COMM_INS;
        psOutApp->cACK=PS_MUST_VERIFY_PWD;	
        psOutApp->pata[0]=PS_MUST_VERIFY_PWD;
        psOutApp->cpataLen=1;
        psOutApp->cDoStatus=DO_WAIT;
	    goto LABEXIT;
    }   
    
    if (pIns[6] == PKG_INS_FG)//ָ 
    {
		//ȡ
		if(pIns[9] == PS_Cancle)
		{
		    psOutApp->cDatStus = COMM_INS;
		    psOutApp->pcDat = gsCommHandle.pImgBuf;
		    psOutApp->dwDatLen = 0;
		    
		    psOutApp->cACK = RT_OK;  
			psOutApp->pata[0] = RT_OK;
			psOutApp->cpataLen = 1;
			psOutApp->cDoStatus = DO_OK;
			flagCmd = 0;
			TMR_Stop(T0);
			DoAppOut(psOutApp);	
			return 0;	
		} 
LABCMD:

#ifdef TRIM_UART
		Switch_144M();
       
#endif
    	cRet = DoCommand(pIns,psOutApp); 
#ifdef TRIM_UART
		Switch_72M();
   
#endif
LABEXIT:    
        if (psOutApp->cDoStatus == DO_WAIT)
    	{
            DoAppOut(psOutApp);
    	}  

    }   
    else    //ݰ 
    {
        PackageDatRec(psPkgRec);
    } 
	return 0;
}
