/***************************************************************************************************
**  File name    : RoscAutoTrim.h
**  Function     : Header of RoscAutoTrim.c		
**  Author       : 
**  Date         : 2015/09/23
**  Version      : v1.0          
**  Description  : The RAT function occupies a GPIO port with interrupt and System tick, 
**					and the GPIO port should be a pull-up port. The GPIO interrupt should
**					be no used in other application. The global interrupt should be enabled.  
**					the best is that the host send byte 0x55 for trimming.                    
**  ModifyRecord : 
**	1. 2015/11/03 coins
**	Modify for supporting baud rate 9600/19200/28800/38400/57600/115200 bps        	
***************************************************************************************************/
#ifndef RAT_H_
#define RAT_H_

/***************************************************************************************************
** Global Macro Definition
***************************************************************************************************/


/***************************************************************************************************
** Global Functon Declaration
***************************************************************************************************/
/****************************************************************************
 * Subroutine:	RAT_GetVersion
 * Function:	to get RAT lib version 
 * Input:		None 
 * Output:		unsigned int	
 * Description:	the higher word for target, the lower word for version.
 *				The version is BCD code, such as 0x0010, is version 0.10 
 * Date:		2015.12.17
 * ModifyRecord:
 * *************************************************************************/
UINT32 RAT_GetVersion(void);

/****************************************************************************
 * Subroutine:	RAT_Init
 * Function:	ROSC auto trimming initialization  
 * Input:       UINT8 nGpioPort -- the GPIO port connected to UART_RX 
 *				UINT8 nGpioBit --  the GPIO bit for the port connected to UART_RX
 *				UINT32 nSysClkFreq -- the system clock frequency, such as 144000000
 *				UINT32 nUartBaudRate --  the UART baud rate, such as 115200
 * Output:		RT_OK or RT_FAIL	
 * Description:	 
 * Date:		2015/11/04
 * ModifyRecord:  nSysClkFreq/nUartBaudRate must be between 500 ~ 167772, return RT_FAIL
***************************************************************************/
UINT8 RAT_Init(UINT8 nGpioPort, UINT8 nGpioBit, UINT32 nSysClkFreq, UINT32 nUartBaudRate);

/****************************************************************************
 * Subroutine:	RAT_Enable
 * Function:	ROSC auto trimming enable  
 * Input:       UINT8
 * Output:		RT_OK or RT_FAIL	
 * Description:	 
 * Date:		2015/09/18
 * ModifyRecord:
***************************************************************************/
UINT8 RAT_Enable(void);

/****************************************************************************
 * Subroutine:	RAT_Disable
 * Function:	ROSC auto trimming disable  
 * Input:       None
 * Output:		None	
 * Description:	 
 * Date:		2015/09/18
 * ModifyRecord:
***************************************************************************/
void RAT_Disable(void);

#endif /*RAT_H_*/
