#include "UARTTrim.h"
#include "RoscAutoTrim.h"
#include "UARTBase.h"

#ifdef TRIM_UART
/***************************************************************************************************/
UINT8 TrimUART_INIT()
{
	UINT8 cRet;
#ifdef TRIM_UART_GPIO
	cRet = RAT_Init(GPIOA,18, SCM_GetSysClk(), gParaTab.CFG_BaudRate*9600);	//GPIOGPIO
#endif

#ifdef TRIM_UART_RX
	cRet = RAT_Init(GPIOA,16, SCM_GetSysClk(), gParaTab.CFG_BaudRate*9600);	//GPIORX
#endif

	if(RT_OK != cRet)
		return RT_FAIL;	
	return RT_OK;
}
/***************************************************************************************************/
void Switch_144M(void)
{
	while(Uart_IsTXFIFOEmpty());
	RAT_Disable();
	ScmRegs.HFROSCCTRL.bit.HFROscCRE = 0;
	SCM_SetSysClk(SYS_CLK_144M);	
	UART_InitBaudrate_Switch(gParaTab.CFG_BaudRate);

}
/***************************************************************************************************/
void Switch_72M(void)
{
	static UINT8 Trimflag = 0;

	SCM_SetSysClk(SYS_CLK_72M);
	ScmRegs.HFROSCCTRL.bit.HFROscCRE = 1;	
	UART_InitBaudrate_Switch(gParaTab.CFG_BaudRate);
	if(0 == Trimflag)
	{
		if(RT_OK == TrimUART_INIT())
			Trimflag = 1;	
	}
	RAT_Enable();
}
/***********************************************************************************
 * Subroutine:	HFROSC_InitTrim
 * Function:	
 * Input:		SYS_CLK nClk -- to specify the system clock.  
 *              UINT8 flagAddr -- to select storage location.
 								  0: none
 								  1: OTP
 								  2: Flash  
 * Output:		UINT8	--			Return result, RT_OK or RT_FAIL
 * Description:
 * Date:		2012.10.26
 * ModifyRecord:
 * ********************************************************************************/
UINT8 HFROSC_InitTrim(SYS_CLK nClk, UINT8 flagAddr)
{
	UINT32 pnTrimVal[2];
	UINT8 nRet;

	if(1 == flagAddr)
	{
		SCM_SetSysClk(nClk);		
		nRet = EFC_OtpRead(EFC_OTP_USER_1, 0, 2, pnTrimVal);
		if(nRet!=RT_OK)
		{
		   return nRet;
		}
	
		if(0x01020304 == pnTrimVal[0])	// the trimming value is valid
		{
			 ScmRegs.HFROSCCTRL.bit.HFROscTrim = (pnTrimVal[1] & 0x3FF);	// load_trimming
			 nRet = RT_OK;
		}
		else if(0xFFFFFFFF == pnTrimVal[0])// need to trimming
		{
			_delay_ms(2000);
			pnTrimVal[1] = ScmRegs.HFROSCCTRL.bit.HFROscTrim; 	// read trimming value
			nRet = EFC_OtpWrite(EFC_OTP_USER_1, 1, 1, &pnTrimVal[1]);
			if(nRet!=RT_OK) return nRet;
			pnTrimVal[0]=0x01020304;
			nRet = EFC_OtpDisWrite(EFC_OTP_USER_1, &pnTrimVal[0]);	
			if(nRet!=RT_OK) return nRet;	
		}
		return nRet;
	}
	else if(2 == flagAddr)
	{
		SCM_SetSysClk(nClk);		  
		nRet = ReadFlash((UINT8 *)pnTrimVal,PARA_TAB_RVS*SFLASH_PAGE_SIZE+256,8);
		if(nRet!=RT_OK)
		{
		   return nRet;
		}

		if(0x01020304 == pnTrimVal[0])	// the trimming value is valid
		{
			 ScmRegs.HFROSCCTRL.bit.HFROscTrim = (pnTrimVal[1] & 0x3FF);	// load_trimming
			 nRet = RT_OK;
		}
		else //if(0xFFFFFFFF == pnTrimVal[0])// need to trimming
		{
			_delay_ms(2000);
			pnTrimVal[1] = ScmRegs.HFROSCCTRL.bit.HFROscTrim; 	// read trimming value
			pnTrimVal[0] = 0x01020304;
			nRet = WriteFlash((UINT8 *)pnTrimVal,PARA_TAB_RVS*SFLASH_PAGE_SIZE+256,8);
			if(nRet!=RT_OK) return nRet;
		}	
		return nRet;	
	}
	return RT_OK;	
}
#endif


