/***************************************************************************************************
**  File name    : UartBase.c
**  Function     :  
**  Author       : yangf
**  Date         : 2013/12/17
**  Version      : v1.0
**  ModifyRecord :
***************************************************************************************************/
/***************************************************************************************************
** Include Header Files
***************************************************************************************************/
#include    "UARTBase.h"
#include    "Uart.h"
#include    "System.h"
#ifdef USE_UART
/***************************************************************************************************
** Local Macro Definition
***************************************************************************************************/


/***************************************************************************************************
** Local Type Definition
***************************************************************************************************/

/***************************************************************************************************
** Local static Variable Declaration
***************************************************************************************************/

/***************************************************************************************************
** Global Variable Declaration
***************************************************************************************************/

UINT8 gUartBuf[512];
/***************************************************************************************************
** Local Functon Declaration
***************************************************************************************************/

/***************************************************************************************************
* Functon
***************************************************************************************************/

/***************************************************************************************************
** Subroutine  : UART_InitBaudrate
** Function    : Uartʼ 
** Input       : UINT8 nBaudrate -- ϵ =9600*nBaudrate 
** Output      : 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void UART_InitBaudrate(UINT8 nBaudrate)
{
	  STRUCT_UART_FORMAT tPRT_FRAME;
	  STRUCT_DATA_BUF RXfifi; 
	  RXfifi.pBuf= gUartBuf;
	  RXfifi.Size=sizeof(gUartBuf);
	  tPRT_FRAME.BaudRate=nBaudrate*9600;
	  tPRT_FRAME.CharBit=8;
	  tPRT_FRAME.Parity=NONE;
	  tPRT_FRAME.StopBit=2;
	  tPRT_FRAME.TxMode=UART_TX_POLLING;
      UART_Init(UARTX,UARTX_MAP,tPRT_FRAME,&RXfifi,NULL);                                                           
}
 /***************************************************************************************************
** Subroutine  : UartSendDataFun
** Function    :  
** Input       : 
** Output      : 
** Description :   
** Date        : 
** ModifyRecord:
***************************************************************************************************/
void UartSendDataFun(UINT8 *pbuf,UINT32 wLen)
{
    UINT32 cont;
    cont=0;
    while (cont<wLen)
    {
        if (UART_SendByte(UARTX,pbuf[cont])==RT_OK)
        {
        	cont++;
        }        	
    } 
    return;   
}
 /***************************************************************************************************
** Subroutine  : Uart_IsTXFIFOEmpty
** Function    :  
** Input       : 
** Output      : 
** Description :   
** Date        : 
** ModifyRecord:
***************************************************************************************************/
UINT8 Uart_IsTXFIFOEmpty(void)
{
    volatile struct USART_REGS * pUart;
	
	pUart = UART_GetRegs(UARTX);
	if(pUart->CSTAT.bit.TxEpt)
		return RT_OK;
	else
		return RT_FAIL;  
}

/***************************************************************************
 * Subroutine:	UART_Init
 * Function:	UART initialization
 * Input:		UINT8 UARTx -- 		UART number, UART0	 UART1
 *				UART_MAP mPortMap-- Select which group of GPIO port as UART
 *                                 UART0_MAP_A16_A17
 *                                 UART1_MAP_A27_A28 
 * 				STRUCT_UART_FORMAT sFrame --
 * 									UART frame format;
 * 				STRUCT_DATA_BUF *pRxBuf --
 * 									UART receive buffer, to specify the buffer and size for receive,
 * 									if pRxBuf is NULL, receiver will be disabled and its pin will be used
 * 									as default (GPIO)
 * 				STRUCT_DATA_BUF *pTxBuf --
 * 									UART transmit buffer, to specify the buffer and size for transmit,
 *									if pRxBuf is NULL and sFrame.TxMode == UART_TX_INT, receiver will be disabled and its pin will be used
 * 									as default (GPIO)
 * Output:		UINT8	--			Return result, RT_OK or RT_FAIL
 * Description:
 * Date:		2012.07.11
 * ModifyRecord:
 * *************************************************************************/
extern UINT8 UART_PortInit(UART_MAP mPortMap);
UINT8 UART_Init_Switch(UINT8 UARTx, UART_MAP mPortMap,STRUCT_UART_FORMAT sFrame, STRUCT_DATA_BUF *pRxBuf, STRUCT_DATA_BUF *pTxBuf)
{
	volatile struct USART_REGS * pUart;

	// 1. to open global control
	switch(UARTx)
	{
		case UART0:
			if(mPortMap != UART0_MAP_A16_A17)
				return RT_PARAM_ERR;
   			ScmRegs.MODCLKCTRL |= 1<<ID_UART0;	 	// enable UART0 clock
			ScmRegs.MODRSTCTRL |= 1<<ID_UART0;	  	// Relinquish from reset
			break;
		case UART1:
			if(mPortMap == UART0_MAP_A16_A17)
				return RT_PARAM_ERR;
   			ScmRegs.MODCLKCTRL |= 1<<ID_UART1;	 	// enable UART0 clock
			ScmRegs.MODRSTCTRL |= 1<<ID_UART1;	  	// Relinquish from reset
			break;
		default:
			return RT_FAIL;
	}
	//2 to select Pins
	if(UART_PortInit(mPortMap) != RT_OK) return RT_FAIL;
			
	// 2. select UART register file
	pUart = UART_GetRegs(UARTx);
	// 3. disable UART transfer and receive
	pUart->GCTL.bit.RxEn = 0;
	pUart->GCTL.bit.TxEn = 0;
	// 4. disable all UART interrupts and clear all interrupt flags
	pUart->INTEN.all = 0;
	pUart->INTCLR.all = 0xffff;
	
	// 5. configure UART frame format
	switch(sFrame.CharBit)
	{
		case CHAR_5BIT:
		case CHAR_6BIT:
		case CHAR_7BIT:
		case CHAR_8BIT:
			pUart->CCTL.bit.Char = sFrame.CharBit-5;
			break;
		default:
			return RT_FAIL;
	}
	switch(sFrame.StopBit)
	{
		case ONE_STOP:
		case TWO_STOP:
			pUart->CCTL.bit.Spb = sFrame.StopBit-1;
			break;
		default:
			return RT_FAIL;
	}
	switch(sFrame.Parity)
	{
		case NONE:
			pUart->CCTL.bit.PEn = 0;
			break;
		case ODD:
			pUart->CCTL.bit.PEn = 1;
			pUart->CCTL.bit.PSel = 0;			
			break;
		case EVEN:
			pUart->CCTL.bit.PEn = 1;
			pUart->CCTL.bit.PSel = 1;			
			break;
		default:
			return RT_FAIL;
	}
	
	if(sFrame.BaudRate == 0) return RT_FAIL;
	pUart->SPBREG = SCM_GetSysClk() / (16 * sFrame.BaudRate);
	
	// 7. to initialize RX FIFO, enable RX interrupt and RX
	if(pRxBuf == NULL)		// no buffer, disable receive
	{
		pUart->GCTL.bit.RxEn = 0;
	}
	else
	{
//		gUartRxFIFO[UARTx].pFFData = pRxBuf->pBuf;		// to initialize receive FIFO
//		gUartRxFIFO[UARTx].FFDepth = pRxBuf->Size;
//		gUartRxFIFO[UARTx].FFValidSize = 0;
//		gUartRxFIFO[UARTx].FFInOffset = 0;
//		gUartRxFIFO[UARTx].FFOutOffset = 0;
		pUart->INTEN.bit.RxiEn = 1;
		pUart->INTEN.bit.RxOerriIEn = 1;		// added by coins	2009.09.17
		pUart->INTEN.bit.RxBrkiEn = 1;
		pUart->INTEN.bit.RxFerriEn = 1;
		pUart->INTEN.bit.RxPerriEn = 1;
		pUart->GCTL.bit.RxEn = 1;				// enable receive
	}

	// 7. to initial TX FIFO, enable TX interrupt and TX
	if(sFrame.TxMode == UART_TX_INT)		// transmit by interrupt
	{
		if(pTxBuf == NULL)				// no buffer for transmit interrupt
		{
			pUart->GCTL.bit.TxEn = 0;		// disable transmit
		}
		else
		{
//			gUartTxFIFO[UARTx].pFFData = pTxBuf->pBuf;		// to initialize transmit FIFO
//			gUartTxFIFO[UARTx].FFDepth = pTxBuf->Size;
//			gUartTxFIFO[UARTx].FFValidSize = 0;
//			gUartTxFIFO[UARTx].FFInOffset = 0;
//			gUartTxFIFO[UARTx].FFOutOffset = 0;
			pUart->INTEN.bit.TxiEn = 1;
			pUart->GCTL.bit.TxEn = 1;		// enable transmit
		}
	}
	else
	{
		pUart->INTEN.bit.TxiEn = 0;
		pUart->GCTL.bit.TxEn = 1;		// enable transmit
	}
	return RT_OK;	
}
/***************************************************************************************************
** Subroutine  : UART_InitBaudrate
** Function    : Uartʼ 
** Input       : UINT8 nBaudrate -- ϵ =9600*nBaudrate 
** Output      : 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void UART_InitBaudrate_Switch(UINT8 nBaudrate)
{
	  STRUCT_UART_FORMAT tPRT_FRAME;
	  STRUCT_DATA_BUF RXfifi; 
	  RXfifi.pBuf= gUartBuf;
	  RXfifi.Size=sizeof(gUartBuf);
	  tPRT_FRAME.BaudRate=nBaudrate*9600;
	  tPRT_FRAME.CharBit=8;
	  tPRT_FRAME.Parity=NONE;
	  tPRT_FRAME.StopBit=2;
	  tPRT_FRAME.TxMode=UART_TX_POLLING;
      UART_Init_Switch(UARTX,UARTX_MAP,tPRT_FRAME,&RXfifi,NULL);                                                           
}
#endif
