/***************************************************************************************************
**  File name    : UARTProtocol.c
**  Function     : UART Эշ 
**  Author       : yangf
**  Date         : 2013/1/17
**  Version      : v1.0
**  Description  : 
**  ModifyRecord :
***************************************************************************************************/

/***************************************************************************************************
** Include Header Files
***************************************************************************************************/
#include  "UARTProtocol.h"
#include  "Protocol.h"
#include  "UARTBase.h"
#include  "System.h"
#include    "RoscAutoTrim.h"
#ifdef USE_UART
/***************************************************************************************************
** Local Macro Definition
***************************************************************************************************/

/***************************************************************************************************
** Local Type Definition
***************************************************************************************************/

/***************************************************************************************************
** Local static Variable Declaration
***************************************************************************************************/

/***************************************************************************************************
** Global Variable Declaration
***************************************************************************************************/
HANDLE_TO_INTERFACE *gpsUartHandle;
/***************************************************************************************************
** Local Functon Declaration
***************************************************************************************************/

/***************************************************************************************************
* Functon
***************************************************************************************************/

/***************************************************************************************************
** Subroutine  : UartProtocolInit
** Function    : ͨѶʼ 
** Input       : HANDLE_TO_INTERFACE *p -- UartЭվ 
**               UINT8 nBaudrate -- ϵ= nBaudrate*9600 
** Output      : 
** Description : Uart ӿڡʼ   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void UartProtocolInit(HANDLE_TO_INTERFACE *p,UINT8 nBaudrate)
{
    UART_InitBaudrate(nBaudrate);
	NVIC_EnableIRQ(UART0_IRQn);//UART0ж
    gpsUartHandle=p;
}

/***************************************************************************************************
** Subroutine  : UART_GetPackage
** Function    : Эպ 
** Input       : PKG_RECVICE *p -- Эվ 
** Output      : 
** Description :    
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void UART_GetPackage(PKG_RECVICE *p)
{
	static UINT8 tmp=0;
	UINT16 ValidLen;
	UINT32 RecTimOut,LimTimOut,nwPKOFCMDLen,i;
	UINT8 *pRec;
	UINT8 cHbuf[2]={0};
	
	ValidLen=UART_GetRxFFValidSize(UARTX);
	if (ValidLen<9)    //ûİͷ ͷ+оƬַ+ʶ+
	   return;
	cHbuf[0]=PKG_HEAD&0xff;
	cHbuf[1]=(PKG_HEAD>>8)&0xff;
    while (tmp!=cHbuf[0])	
    {
    	UART_ReceByte(UARTX,&tmp);
    	if (ValidLen==0) return;
    	else ValidLen--;
    } 
    
    if (ValidLen<8)    //ûİͷ ͷ+оƬַ+ʶ+
	   return;
    tmp=0;
    pRec=p->pInsBuf;
	memset(pRec,0,9); //ͷ+оƬַ+ʶ+ Ϊ0 
	pRec[0]=cHbuf[0];

    UART_ReceBuf(UARTX,&pRec[1],1);
	if (pRec[0]!=cHbuf[0]||pRec[1]!=cHbuf[1])
	{
		if (pRec[1]==cHbuf[0])
			tmp=pRec[1];	
		return;
	} 
	UART_ReceBuf(UARTX,&pRec[2],7);	

    nwPKOFCMDLen = (((UINT16)pRec[7]& 0xff) << 8) + (pRec[8] & 0xff);		
	if(nwPKOFCMDLen > (gsCommHandle.dwPktSize+2))
		return;
    i = 0;
    RecTimOut = 0;
	LimTimOut = SCM_GetSysClk() / (gParaTab.CFG_BaudRate * 9600) * 20 * 85 / 70;//whileһѭ70ϵͳʱӣһ֡ݼ20Bȣʱʱ䶨Ϊ85֡ʱ䡣
    while (i<nwPKOFCMDLen)
    {
        if (UART_ReceByte(UARTX,&pRec[9+i])==RT_OK)
        {
            i++;
            RecTimOut=0;	
        }  
        else
        {
            if (RecTimOut++>LimTimOut)
                return;
        }                      
    }

    p->wPkgLen=nwPKOFCMDLen+COMM_PAKGE_LEN;
    p->cInterfaceTy=COMM_UART;      
	return;
}
/***************************************************************************************************
** Subroutine  : UARTSendImagePkg/ UARTSendDatPkg
** Function    : ͼƬ/ݣͼƬUartǰֽڴ 
** Input       : PKG_SEND *psSendPkg -- ݷ; 
**               UINT32 PkgMaxLen -- Uartÿ 
** Output      : 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
/* ͼƬڰֽڴ */
void UARTSendImagePkg(PKG_SEND *psSendPkg,UINT32 PkgMaxLen)
{
#ifdef USE_UART      
	UINT32 nLen;
	nLen=psSendPkg->dwDtLen/2;
	
	while(nLen>PkgMaxLen)
	{ 	 
    	psSendPkg->wPkgLen=MakePackageCpt(psSendPkg->pDtBuf,psSendPkg->pInsBuf,PkgMaxLen*2,0x02);
        UartSendDataFun(psSendPkg->pInsBuf,psSendPkg->wPkgLen);
        psSendPkg->pDtBuf+=PkgMaxLen*2;
		nLen-=PkgMaxLen;
	}

	if(nLen)
	{
	    psSendPkg->wPkgLen=MakePackageCpt(psSendPkg->pDtBuf,psSendPkg->pInsBuf,nLen*2,0x08);
        UartSendDataFun(psSendPkg->pInsBuf,psSendPkg->wPkgLen);
	}
#endif
}
/* ݣȫֽڴ */
void UARTSendDatPkg(PKG_SEND *psSendPkg,UINT32 PkgMaxLen)
{
#ifdef USE_UART      

	UINT32 nLen;
	nLen=psSendPkg->dwDtLen;
	
	while(nLen>PkgMaxLen)
	{ 	 
    	psSendPkg->wPkgLen=MakePackage(psSendPkg->pDtBuf,psSendPkg->pInsBuf,PkgMaxLen,0x02);
        UartSendDataFun(psSendPkg->pInsBuf,psSendPkg->wPkgLen);
        psSendPkg->pDtBuf+=gsCommHandle.dwPktSize;
		nLen-=gsCommHandle.dwPktSize;
	}

	if(nLen)
	{
	    psSendPkg->wPkgLen=MakePackage(psSendPkg->pDtBuf,psSendPkg->pInsBuf,nLen,0x08);
        UartSendDataFun(psSendPkg->pInsBuf,psSendPkg->wPkgLen);
	}
#endif
}


/***************************************************************************************************
** Subroutine  : UartPkgDatSend
** Function    : UartЭ 
** Input       : PKG_SEND *psSendPkg -- ݷ; 
**               UINT32 PkgMaxLen -- Uartÿ 
** Output      : 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void UartPkgDatSend(PKG_SEND *psSendPkg,UINT32 PkgMaxSize)
{
    UartSendDataFun(psSendPkg->pInsBuf,psSendPkg->wPkgLen);//Ӧ 
    
    switch (psSendPkg->cPkgTy)
    {
    	case COMM_INS:
            break;
        case COMM_DATA_SEND:
            UARTSendDatPkg(psSendPkg,PkgMaxSize);   //ͺ 
            break;
        case COMM_IMG_SEND:
            UARTSendImagePkg(psSendPkg,PkgMaxSize); //ͺ 
            break;
        default:
            break;     
    }
}

/***************************************************************************************************
** Subroutine  : UARTRecDatPkg/ UARTRecImgPkg
** Function    : Uart/ͼƬ  
** Input       : PKG_RECVICE *p -- Uart/ͼƬ 
** Output      : 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
/* UartͼƬ ȫֽڴ*/
UINT32 UARTRecDatPkg(PKG_RECVICE *p)
{
	UINT32 tLen;
	GetDatFrompkg(p->pInsBuf,p->pDtBuf+p->dwDataOffset,&tLen);
    return  tLen;
}
/* UartͼƬ ڰֽڴ*/
UINT32 UARTRecImgPkg(PKG_RECVICE *p)
{
	UINT32 tLen;
	GetDatFrompkgCpt(p->pInsBuf,p->pDtBuf+p->dwDataOffset,&tLen);
    return  tLen;	  
}
/***************************************************************************************************
** Subroutine  : UartPkgDatRecg
** Function    : Uartݰ 
** Input       : PKG_RECVICE *p -- Uartݾ 
** Output      : 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT32 UartPkgDatRec(PKG_RECVICE *p)
{
    UINT32 lwLen;
    lwLen=0;

	p->cInterfaceTy=NO_COMM_WORK;
    switch (p->cPkgTy)
    {
    	case COMM_INS:                     
    	case COMM_DATA_REC:
    	    if (p->dwDataOffset<p->dwDtLen)
    	    {
                lwLen=UARTRecDatPkg(p);
                p->dwDataOffset+=lwLen;
//    	    	p->pDtBuf=p->pDtBuf+p->dwDataOffset;
    	    }   
            else
            {
            	p->cPkgTy=COMM_INS;
            }             	    
            break;
        case COMM_IMG_REC:                
            if (p->dwDataOffset<p->dwDtLen)
    	    {
                lwLen=UARTRecImgPkg(p);
                p->dwDataOffset+=lwLen;
//    	    	p->pDtBuf=p->pDtBuf+p->dwDataOffset;
    	    } 
    	    else
    	    {
    	    	p->cPkgTy=COMM_INS;
    	    }    	    
            break;
       default : 
            break;
    }
    return 	lwLen;
}

#endif








