/***************************************************************************************************
** File name   : FPxx.h
** Function    :
** Author      : zougl
** Date        : 2013/10/14
** Version     : v1.5
** Description :
** ModifyRecord:
***************************************************************************************************/
#ifndef FPXX_H_
#define FPXX_H_
#include "Spi.h"

#if (SENSOR_CHOICE == FP300)
#define   USB_DATA_8K      0x2000
#define   USB_DATA_36K     0x9000

#pragma anon_unions
//------------------------Read image choice----------------------

#define CHIP_NAME				"FAP10"     /**< finger print sensor model name */
#define StartX                  0           /**< sensor pixel start X point */
#define StartY                  1           /**< sensor pixel start Y point */
#define SizeX					360UL//160UL	        /**< sensor pixel number per line */
#define	SizeY					256UL//160UL	        /**< sensor total line number */
#define X_MAX					(SizeX-1+StartX)
#define	Y_MAX					(SizeY-1+StartY)
#define OTP_BYTE_SIZE   		64          /**< OTP size of sensor */

#define Sub_Frame               12
#define Channel                 32


#define     IMG_SIZE1                     0   //256*360 , synochip's algo is not fully ready.
#define     IMG_SIZE2                     1    //256*288
#define     CHANGE_IMG_SIZE               IMG_SIZE1 //to select image size

#if(CHANGE_IMG_SIZE == IMG_SIZE1)
#define   USB_DATA_SIZE     0xB400

#elif(CHANGE_IMG_SIZE == IMG_SIZE2)
#define   USB_DATA_SIZE     USB_DATA_36K

#endif

#define     SOFT_RESET      1
#define     GPIO_RESET      0
#define OSCTRIM_RANGECHK(a) (a>0x1F? (0x1F) : (a))



/**
 * @defgroup groupSensorChip ID
 * \brief Definition of Fingerprint sensor chip ids
 @{
 */


#define CHIP_ID_iG102		0xF130
#define CHIP_ID_iG102A		0xF131
#define CHIP_ID_iG102B		0xF132
/**
 @}
*/


/**
 * @defgroup group iMD Register iG101 Registers
 * \brief iG101 register address
 @{
 */
#define REG_CHIPID_H    	    0x00    /**< chip ID high */
#define REG_CHIPID_L		    0x01    /**< chip ID low */
#define REG_AFE_CONTROL         0x02    /**< afe control */
#define REG_ADC_CONTROL	        0x03    /**< adc control */
#define REG_VLDO_TRM		    0x04    /**< vldo trim */
#define REG_VR_TRM              0x05    /**< vr trim */
#define REG_QP_TRM              0x06    /**< qp trim */
#define REG_CALIB_OFS   	    0x07    /**< offset calibrating */
#define REG_CLOCK_CYCLE  	    0x08    /**< operation clock control */
#define REG_SEL_NUM 		    0x09    /**< H_SEL max count */
#define REG_BIST_STATUS         0x0A    /**< Bist status and error message */
#define REG_RST_DELAY       	0x0B    /**< RST delay time from INT_VD */
#define REG_RST_WIDTH           0x0C    /**< RST pulse width*/
#define REG_INT_HD_DELAY        0x0D    /**< INT_HD delay time from RST fall edge */
#define REG_RG_RSV_0            0x0E    /**< reserved byte 0 */
#define REG_RG_RSV_1            0x0F    /**< reserved byte 1 */
#define REG_RG_DIG_RSV          0x10    /**< digital reserved byte */
#define REG_DIG_TEST            0x11    /**< option of test */
#define REG_INT_HD_WIDTH        0x12    /**< INT_HD delay time from EXVCOM */
#define REG_RESERVED            0x13    /**< */
#define REG_EXVCOM_DELAY        0x14    /**< EXVCOM delay time from INT_HD */
#define REG_EXVCOM_WIDTH        0x15    /**< EXVCOM pulse width */
#define REG_EXVCOM_NUM          0x16    /**< EXVCOM plus number */
#define REG_EXVCOM_RST          0x17    /**< EXVCOM pulse number/delay in RST */
#define REG_OSC         	    0x18    /**< oscillator */
#define REG_ANA_TEST 		    0x19    /**< analog tester */
#define REG_RG_ANA_RSV          0x1A    /**< analog reserved byte */
#define REG_LSF_TDAC        	0x1B    /**< linear shift tdac */
#define REG_RG_OTP_ADDR_BIT     0x1C    /**< OTP address & bit enable*/
#define REG_RG_OTP_CTRL         0x1D    /**< OTP write control */
#define REG_RD_OTP_dtat         0x1E    /**< OTP read data */
#define REG_PAGE                0x1F    /**< page selection */
/**
 @}
*/


#define BIT_EN_CP       	    0x02    /**< enable cp */
#define BIT_RST_TOUCH    	    0x04    /**< touch reset*/
#define BIT_EN_ANALOG		    0x08    /**< analog clock force enable */
#define BIT_EN_CHIP             0x80    /**< enable chip */
#define BIT_EN_OSC              0x40


#define CMD_BURSTREAD_PIXELDATA_256	0x04
#define CMD_BURSTREAD_PIXELDATA_32	0x06



/**
 * @defgroup groupStatusBits Sensor status bits
 * \brief Bit definition of status
 @{
 */


#define BIT_DFE_DATA_NUMBER_IG   0x08
#define BIT_FIFO_EMPTY_IG        0x10
#define BIT_FIFO_HALF_FULL_IG    0x20
#define BIT_FIFO_FULL_IG         0x40
#define BIT_IMGSCAN_ACTIVE_IG    0x80



/**************************************************************
--------------- sensor macro declare from here ---------------
**************************************************************/
#define DETEN_ON    0x20
#define DETEN_OFF   0xDF

#define HIGHCAP     0x00
#define LOWCAP      0x08

#define	FreqUart	108E6

#define MASTER	    1
//#define MASTER	    0x20
#define SLAVE		0
#define MSB			0
#define LSB			1
#define MODE0		0
#define MODE1		1
#define MODE2		2
#define MODE3		3

/**************************************************************
-------------- Detect fingers addr from here --------------
**************************************************************/
#define     VALUE        10
#define     AVEROFBLOCK  0x10
#define     VERVAL       0x20

#define     FGLIMIT_NUM  20//0x3C

/**************************************************************
-------------- OTP Read --------------
**************************************************************/
// Command definitions
#define CMD_DUMMY           0x00
#define CMD_READ_REG        0x20
#define CMD_WRITE_REG       0x40
//Register bit definitions
#define REG_OTP_ADDRESS     0x04
#define REG_OTP_TESTMODE    0x05    /**< otp test mode */
#define REG_OTP_WRITE       0x05
#define REG_OTP_CONTROL     0x06
#define REG_OTP_READ_DATA   0x07


// Bit Definition of REG_OTP_CONTROL, reg0x06
/**
 * @defgroup groupRegOTPControlBits   Reg otp control bits
 * \brief Bit definition of reg_otp_control, page0 reg0x06
 @{
 */
#define BIT_OTP_CEB             0x01
#define BIT_OTP_RST             0x02
#define BIT_OTP_PPROG           0x04
#define BIT_OTP_CHIP_DIN       	0x08


#define REG_RG_OTP_ADDR_BIT     0x1C    /**< OTP address & bit enable*/
#define REG_RG_OTP_CTRL         0x1D    /**< OTP write control */
#define REG_RD_OTP_dtat         0x1E    /**< OTP read data */
#define REG_OTP_ADDR_MASK       0xF8
#define REG_OTP_WDAT_MASK       0x07
#define REG_OTP_CTRL_MASK       0x0F
#define REG_OTP_RDAT_MASK       0xFF

#define BIT_OTP_CHIP_ENABLE     0x01
#define BIT_OTP_CHIP_RESET      0x02
#define BIT_OTP_CHIP_PROGRAM    0x04
#define REG_PAGE                0x1F    /**< page selection */
/**************************************************************
-------------- Flash Read --------------
**************************************************************/
#define FLASH_RUN_NUM        300200                          //ȡ
#define FLASH_RUN_FLAG       300204                          //¼־

#define FLASH_FP_REG        FLASH_RUN_NUM+0x400             //Ĵô

//#define TEST_COUNT_MODE
/*  ȡָƽ */
#define FG_OK			0 //ȡָƳɹ
#define FG_FAIL			1 //ȡָʧ
#define FG_NO			2 //ָ
#define TIMER0_INT		3 //ж

//ָģʽ
#define SLEEP_MODE			0 //ȡָʧ
#define NORMAL_MODE			1 //ָ




typedef enum ePAGENUM_t
{
    PAGE0 = 0,
    PAGE1,
    PAGE2,
    PAGENULL = 0xFF
} ePAGENUM;

typedef struct subFrameStatusChk
{
	UINT32	uiHistogram[2][256];
	UINT32  uiSimilarHist[256];
	UINT32	uiTotalSimilar; 
    float	flTotalSimilar;
	UINT16	iHistogramPxlNum[2];
} st_subFrameSimilarityChk, * st_subFrameSimilarityChk_ptr;


/**
 * @typedef FPCONFIG Fingerprint register and spi setting structure.
 * \brief FP Sensor Register Structure and spi clock setting.
 @{
 */
typedef struct
{
    U8   RegVer;            /**< Version of default register table which write in OTP */
    U8   Reg0;              /**< Reg0x00, bit[3:0] div_opclk */
    U8   Reg1;              /**< Reg0x01, bit[7:4] pga2_gain, bit[1:0] pga1_gain */
    U8   Reg2;              /**< Reg0x02, bit[7:0] dc offset */
    U8   Reg3;              /**< Reg0x03, bit[6:4] adc bias, bit[3:2] adc vrt, bit[1:0] adc vrb */
    U8   Reg4;              /**< OTP address */
    U8   Reg5;              /**< OTP write data */
    U8   Reg6;              /**< OTP control register. */
    U8   Reg7;              /**< OTP read data */
    U8   Reg8;              /**< Reg0x08, bit[7:0] det threshold */
    U8   Reg9;              /**< Reg0x09, bit[7:0] det divider */
    U8   RegA;              /**< Reg0x0A, bit[7] en_window, bit[6] en_inscan, bit[5] en_det, bit[3] en_lowcap, bit[2] en_osc, bit[0] en_analog */
    U8   RegB;              /**< Reg0x0B, bit[6] en_intr, bit[4:0] en_bits */
    U8   RegC;              /**< Reg0x0C, LLX */
    U8   RegD;              /**< Reg0x0D, LLY */
    U8   RegE;              /**< Reg0x0E, URX */
    U8   RegF;              /**< Reg0x0F, URY (In SF301, it is ch_mode)*/
    U8   Reg10;             /**< Reg0x10, ch_mode */
    U8   Reg11;             /**< Reg0x11, in_scan_line */
    U8   Reg12;             /**< Reg0x12, in_detect_line */
    U8   Reg13;             /**< Reg0x13, analog_rosc */
    U8   Reg14;             /**< Reg0x14, analog_fdet */
    U8   Reg15;             /**< Reg0x15, internal usage */
    U8   Reg16;             /**< Reg0x16, internal usage */
    U8   Reg17;             /**< Reg0x17, internal usage */
    U8   Reg18;
    U8   Reg19;
    U8	 Reg1A;
    U8	 Reg1B;
    U8	 Reg1C;
    U8   Reg1D;
    U8	 Reg1E;
    U8	 Reg1F;            /**< Reg0x1D, internal usage */
    U8   Reg[2][32];

    U8   sysclk;
    U8   spiclk;            /**< Platform SPI clock */
    U8   testpin;           // test pin config
    U8   bufbias;           // buffer bias
    U8   options;           // bit 0: auto-offset
    U8 RXChannelOfs[32];
} FPCONFIG;





/**
 * @typedef BIT_FIELD Bit file definition
 * \brief Bit field structure used in OTP read write.
 @{
 */
typedef struct
{
    U8   Bit0  : 1;
    U8   Bit1  : 1;
    U8   Bit2  : 1;
    U8   Bit3  : 1;
    U8   Bit4  : 1;
    U8   Bit5  : 1;
    U8   Bit6  : 1;
    U8   Bit7  : 1;
} BIT_FIELD;


typedef struct
{
    U8  Reg0;
    U8  Reg1;
    U8  Reg2;
    U8  Reg3;
    U8  Reg4;
    U8  Reg5;
    U8  Reg6;
    U8  Reg7;
    U8  Reg8;
    U8  Reg9;
    U8  RegA;
    U8  RegB;
    U8  RegE;
    U8  RegF;
    U8  Reg10;
    U8  Reg11;
    U8  Reg12;
    U8  Reg1D;
    U8  Reg1E;
    U8  Reg1F;
} Page1;



typedef struct
{
    U8  Version;    /**< Version of structure */
    U8  WaferSerialNum;
    U8  WaferAddr_X;
    U8  WaferAddr_Y;
} OTP_CHIP_SERIAL_NUMBER, *OTP_CHIP_SERIAL_NUMBER_PTR;

/**
 * @typedef OTP_CALI_DATA_3_0 OTP calibration data 3.0 memory map
 * \brief OTP calibration data 3.0 structure. The physical address is at OTP Byte4~27 (start from 0).
 @{
 */
typedef struct
{
    union
    {
        struct {
            U8		    CurrentTrim;
            U8		    OSCTrim;
            U8		    V2P4Trim;
            U8		    V1P8Trim;
            U8		    QPTrim;
            union {
                U8		VRTrim;
                struct {
                    U8 Bit6_0 : 7;
                    U8 Bit7    : 1;
                } VRTrimIndex;
            } stVRTrim;
            U8			Checksum;
        } CPTrim;
        struct
        {
            U8      Byte[7];
        } CPDataByte;
    };
    union
    {
        struct
        {
            U8	    VR;
            U8		TDAC;
            U8		Gain;
            U8		DCOffset;
            U8		Reserve1;
            U8		Reserve2;
            U8		Checksum;
        } ICCalibData;
        struct
        {
            U8      Byte[7];
        } ICCalibDataByte;
    };
    union
    {
        struct
        {
            U8		DCOffset;
            U8		Gain;
            union
            {
                U8		RXChannelHB;
                struct
                {
                    U8 Bit1_0 : 2;
                    U8 Bit3_2 : 2;
                    U8 Bit5_4 : 2;
                    U8 Bit7_6 : 2;
                } RXHBIndex;
            } RX_HByte;
            union
            {
                U8		RXChannelLB;
                struct
                {
                    U8 Bit4_0 : 5;
                    U8 Bit7_5 : 3;
                } RXLBIndex;
            } RX_LByte_1;
            union
            {
                U8		RXChannelLB;
                struct
                {
                    U8 Bit4_0 : 5;
                    U8 Bit7_5 : 3;
                } RXLBIndex;
            } RX_LByte_2;
            union
            {
                U8		RXChannelLB;
                struct
                {
                    U8 Bit4_0 : 5;
                    U8 Bit7_5 : 3;
                } RXLBIndex;
            } RX_LByte_3;
            union
            {
                U8		RXChannelLB;
                struct
                {
                    U8 Bit4_0 : 5;
                    U8 Bit7_5 : 3;
                } RXLBIndex;
            } RX_LByte_4;
            union
            {
                U8        CoatingData;
                struct
                {
                    U8		CoatingThickness : 4;
                    U8		CoatingColor     : 4;
                } DataIndex;
            } COATING_DATA;
            U8		CoatingVendor;
            U8			Checksum;
        }   ModuleCalibData;
        struct
        {
            U8      Byte[10];
        } ModuleCalibDataByte;
    };
} OTP_CALI_DATA_3_0, *OTP_CALI_DATA_3_0_PTR;


typedef union
{
    U16		id;
    U8		byte[2];
} CHIP_ID;


typedef struct
{
    U8        size;             //OTP size
    U8        regHAddr;         //reg high byte address
    U8        regAddr;          //reg low byte address
    U8        regAddrMask;      //OTP data bit mask
    U8        regWdat;          //reg write data, write protect
    U8        regWdatMask;      //OTP data bit mask
    U8        regCtrl;          //reg control
    U8        regCtrlMask;      //OTP data bit mask
    U8        regRdat;          //reg read data
    U8        regRdatMask;      //OTP data bit mask

    U8        chipEnable;       //command of chip enable
    U8        chipReset;        //command of chip reset
    U8        chipProgram;      //command of chip program
    U8        chipWP;           //command of chip write protect
    U8        chipInitPhs;      //OTP init phase
    U8        chipEnPhs;        //OTP enable phase
    U8        chipRstPhs;       //OTP reset phase
    U8        chipOffPhs;       //OTP turn off phase
    U8        chipPrgPhs;       //OTP program phase
    // For OTP Type E64
    U8        regTM;            //reg OTP test mode
    U8        regTMMask;        //reg OTP test mode mask
    U8        chipStandby;      //OTP standby mode
    U8        chipReadAccess;   //OTP read mode
    U8        chipProgramEntry; //OTP program entry mode
    U8        chipProgramAccess;//OTP program access mode
    U8        chipTMM0;         //OTP none TM mode setting
    U8        chipTMM1;         //OTP TM mode 1 setting
    U8        chipTMM2;         //OTP TM mode 2 setting
    void      (*OTPfn_ReadByte)(U8, U8 *);    //OTP read function
//    void      (*OTPfn_WriteByte)(U8, U8);     //OTP write function
//    void      (*OTPfn_WriteProtectByte)(U8);  //OTP write protect function
} OTP_CONTROL;



typedef struct
{
    char*		chipName;		/**< Chip name */
    CHIP_ID		chipID;			/**< Chip ID */
    U8          PackageType;    /**< Chip package type */
    FPCONFIG	config;			/**< Register name */
    Page1	    page1;                  /**< Page 1 register */
    OTP_CONTROL	OTP;			/**< OTP control parameter */
    U8			regChgMode;		/**< reg change mode */
    U16			sizeX;			/**< row pixel of sensor */
    U16			sizeY;			/**< column pixel of sensor */
    U16         firstPixelDelay;        /**< before scan command, delay time */
    U8          regStatus[32];          /**< register status */
    U8          BistValue[18];   //BistValue[0] is test result
} SENSOR;




typedef struct
{
    UINT8 Version;
    UINT16 Width;
    UINT16 Height;
    UINT8  OTPSize;
} SENSOR_CAPABILITY, *SENSOR_CAPABILITY_PTR;



typedef struct
{
    UINT8          GainRound;   /**< Gain ratio value in round up */
    UINT8          RegGain;     /**< Reg0x01 gain1 and gain2 register setting value */
    float       GainReal;    /**< Gain ratio real value with floating point */
    UINT8          RegDCOffSet; /**< Reg0x02 dc offset register value */
} Gain2DCOffSet, *Gain2DCOffSet_PTR;




typedef struct
{
    UINT16 Histogram[128];			/**< Full image histogram */
    UINT8  Mean;					/**< Full image average gray scale */
    INT16  STD;						/**< Full image standard deviation */
    UINT8  Max;						/**< Full image maximum */
    UINT8  Min;						/**< Full image minimum */
} IMGPREPROS_INFO, *ptIMGPREPROS_INFO;

enum E_SENSOR_STATE
{
    eSensorState_Sleep=0x00,    //Power off state
    eSensorState_Standby,       //Power on and register initialization done.
    eSensorState_Null=0xFF,
};





extern Gain2DCOffSet g_GN2DCLookupTable[];
extern void stc_GN2DCLookupTableGen(UINT8 a_bRegGain, UINT8 a_bRegDCCali);

/**************************************************************
-------------- Extern function declare from here --------------
**************************************************************/
extern void SensorPortInitial(void);
extern void DisCs(void);
extern void EnCs(void);
extern void SetRst(void);
extern void ResetRst(void);
extern void ComInitial(void);
extern UINT8 SensorWriteByte(UINT8 bData);
extern UINT8 SensorReadByte(UINT8 *pData);
extern UINT8 FPXReadByte(UINT8 bSpiNum, UINT8 *pData);
extern void FPXGetCapability(SENSOR_CAPABILITY_PTR apt_SensorCap);
extern UINT8 FPXGetImageByFileType(UINT8 *apImageBuf, UINT32 *apImgSizeLeft, UINT32 aSize2Read, UINT32 *apSizeReaded);
extern BOOL FP_DETCtrlCheck(void);

void FP_ReadOTPByte(UINT8 uByteAddr, UINT8 *uByteData);
void FP_detect (void);
void FP_deten (UINT8 onoff);
UINT8 FPXInit(void);
UINT8 FPXPortInit(void);
UINT8 FPXGetImage(bool mode);
UINT8 DetectFinger(void);
UINT8 SensorWriteReg(UINT8 bAddr, UINT8 bData);
UINT8 SensorReadReg(UINT8 bAddr, UINT8 *pbData);


#define BIT_FIFO_EMPTY		    0x10
#define BIT_FIFO_HALF_FULL	    0x20
#define BIT_FIFO_FULL	        0x40
#define BIT_IMGSCAN_ACTIVE	    0x80
#define BIT_DET_INTERRUPT	    0x20
#define BIT_DET_RESULT_OK	    0x40
#define CMD_READ_PIXELDATA      0x01
#define CMD_START_SCAN          0x02
#define CMD_SOFTWARE_RESET      0xC0
#define CMD_READ_STATUS         0x03

//k#define SPI_RW(data)  	SPI_RW_FAST(SPI0, data)

typedef struct
{
    U8 Reg2, RegA, RegC, RegD, RegE, RegF, Reg14;
} Config_Reg;


//extern volatile struct USART_REGS *gSpi;
__STATIC_INLINE U8 SPI_RW_FAST(U8 bspiNum,U8 write)
{
    UINT32 lWaitTime;
    volatile struct USART_REGS *pSpi;
    pSpi=SPI_GetRegs(bspiNum);
    lWaitTime= 8* pSpi->SPBREG;

//
    pSpi->TXREG = write;
    while(!pSpi->CSTAT.bit.RxAvl)	// receive available
    {
        if(lWaitTime-- == 0)
            return 0x00;
    }

    return pSpi->RXREG;
}




extern volatile struct USART_REGS *gSpi;
__STATIC_INLINE U8 SPI_RW(U8 write)
{
    UINT32 lWaitTime = 8 * gSpi->SPBREG;
    gSpi->TXREG = write;
    while(!gSpi->CSTAT.bit.RxAvl)	// receive available
    {
        if(lWaitTime-- == 0)
            return 0x00;
    }

    return gSpi->RXREG;
}

/**************************************************************
------------ Write One byte to fingerprint sensor -------------
**************************************************************/
//#define SensorWriteByte(data) SPI_RW(data)
/**************************************************************
----------- Read One byte from fingerprint sensor -------------
**************************************************************/
//#define SensorReadByte(pData) *pData=SPI_RW(*pData);

UINT16 FPX_ChipId(void);

extern U8 NotePadMsg[32];

#endif
#endif
