;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File name    :	SpiFast.s
; Function     :	the fast optimization for SPI in master mode  
; Author       : 	Coins
; Date         :	2014/04/15
; Version      : 	v1.0
; Description  :   
; ModifyRecord :
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Include Header Files
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local Macro Definition
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SCM_REG_BASE_ADDR		EQU		0x40000000		; SCM
MODCLKCTRL				EQU		0x04
MODRSTCTRL				EQU		0x08
ID_SPI0					EQU		0x05
ID_GPIO					EQU		0x01

GPIO_REG_BASE_ADDR		EQU		0x40004000		; GPIO
USE0					EQU		0x00
MUX_SPI					EQU		0x01

SPI0_REG_BASE_ADDR		EQU		0x40014000 		; SPI0 
SPI1_REG_BASE_ADDR		EQU		0x4006C000		; SPI1
TXREG		EQU			0x00
RXREG		EQU			0x04
CSTAT		EQU			0x08
INTSTAT	   	EQU			0x0C
INTEN	   	EQU			0x10
INTCLR	   	EQU			0x14
GCTL	   	EQU			0x18
CCTL	   	EQU			0x1C
SPBREG	   	EQU			0x20
TXEN		EQU			3
RXEN		EQU			4
TXEPT		EQU			0
RXAVL		EQU			1
TXFULL		EQU			2
DUMMYS		EQU			0x01 	; define the dummy byte for read

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local static Variable Declaration
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Global Variable Declaration
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local Functon Declaration
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Functon
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		AREA    |.text|, CODE, READONLY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Subroutine:	SPI_GetRegAddr	
; Function:		Get SPI register file address	
; Input:		UINT8 nSpiNum -- 	SPI number, SPI 0/1										
; Output:		UINT32	--			Return SPIx register file address														
; Description:	
; Date:			2014/04/15	
; ModifyRecord:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
				ALIGN
SPI_GetRegAddr	PROC
				CMP		R0, #0x00
				BNE		NotSpi0
				LDR		R0, SPI0RegAddr
				B		EndSpiGetRegAddr
NotSpi0			CMP		R0, #0x01
				BNE		NotSpi1
				LDR		R0, SPI1RegAddr
				B		EndSpiGetRegAddr
NotSpi1
				MOVS	R0, #0
EndSpiGetRegAddr
				BX		LR
				ENDP

SPI0RegAddr		DCD		SPI0_REG_BASE_ADDR
SPI1RegAddr		DCD		SPI1_REG_BASE_ADDR


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Subroutine:	SPI_Init
; Function:	SPI initialization
; Input:		UINT8 nSpiNum -- 	SPI number, Spi0;
; 				STRUCT_SPI_FORMAT sFrame -- 
; Output:		UINT8	--	Return result, RT_OK or RT_FAIL
; Description:
; Date:		2014.06.05
; ModifyRecord:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
			ALIGN
SPI_INIT	PROC
			EXPORT  SPI_INIT
			PUSH	{R3-R7, LR}			
			MOVS	R7,#0x01				;ʼֵΪRT_FAIL
			CMP		R0, #0				  	;ǷSPI0
			BNE		EndSpiInit				;SPI0ֱӷ
			LDR		R3,ScmRegAddr			;ȡSCMģ׵ַ
;λSPI0ģ
			MOVS	R4, #0x01				;R4 = 1
			LSLS	R5,R4,#ID_SPI0			;R5 = 1<<R4
			LDR		R4, [R3, #MODRSTCTRL]	;R4 = ScmRegs.MODRSTCTRL
			BICS	R4,R4,R5				;R4 = R4&(~R5)
			STR		R4, [R3, #MODRSTCTRL]	;ScmRegs.MODRSTCTRL = ScmRegs.MODRSTCTRL&(~(1 << ID_SPI0))

;ͷSPI0GPIOģ鸴λ
			MOVS	R4, #0x01				;R4 = 1
			LSLS	R5,R4,#ID_SPI0			;R5 = R4<<ID_SPI0
			LSLS	R6,R4,#ID_GPIO			;R6 = R4<<ID_GPIO
			ORRS	R5,R5,R6				;R5 = (1<<ID_SPI0)|(1<<ID_GPIO)
			LDR		R4, [R3, #MODRSTCTRL]	;R4 = ScmRegs.MODRSTCTRL
			ORRS	R4,R4,R5				;R4 = R4|R5
			STR		R4, [R3, #MODRSTCTRL]	;ScmRegs.MODRSTCTRL = ScmRegs.MODRSTCTRL|(1<<ID_SPI0)|(1<<ID_GPIO)

;ʹSPI0GPIOģʱ
			LDR		R4, [R3, #MODCLKCTRL]	;R4 = ScmRegs.MODCLKCTRL
			ORRS	R4,R4,R5				;R4 = R4|R5
			STR		R4, [R3, #MODCLKCTRL]	;ScmRegs.MODCLKCTRL = ScmRegs.MODCLKCTRL|(1<<ID_SPI0)|(1<<ID_GPIO)

;GPIOUSEλSPI
			LDR		R3,GpioRegAddr			;R3 = GpioRegAddr
			MOVS	R5,#0xFF				;R5 = 0xFF
			MOVS	R4,#0xF					;R4 = 0x0F
			LSLS	R5,#0x04				;R5 = R5<<4
			ORRS	R5,R5,R4				;R5 = 0xFFF
			LDR		R4,[R3,#USE0]			;R4 = GpioRegs.USE0
			BICS	R4,R4,R5				;GpioRegs.USE0 = GpioRegs.USE0 &(~0x0FFF)
			MOVS	R6,#MUX_SPI				;R6 = MUX_SPI
			MOVS	R5,R6					;R5 = R6
			LSLS	R6,R6,#4				;R6 = R6<<4
			ORRS	R5,R5,R6				;R5 = R5|R6
			LSLS	R6,R6,#4				;R6 = R6<<4
			ORRS	R5,R5,R6				;R5 = 0x0555
			ORRS	R4,R4,R5				;R4 = R4|R5
			STR		R4,[R3,#USE0]			;GpioRegs.USE0 = GpioRegs.USE0|0x0555

;ȡSPI0׵ַ
			BL		SPI_GetRegAddr			;R0 = SPI0_REG_BASE_ADDR

;pSpi->GCTL.all = 0x0002;
			MOVS	R4,#0x02				;R4 = 0x02
			STR		R4,[R0, #GCTL]			;pSpi->GCTL.all = R4;

;pSpi->INTEN.all = 0x0000;			
			MOVS	R4,#0x00				;R4 = 0x00
			STR		R4,[R0, #INTEN]			;pSpi->INTEN.all = R4;

;pSpi->INTCLR.all = 0xffff;
			MVNS	R4,R4 					;R4 = ~R4
			STR		R4,[R0, #INTCLR]		;pSpi->INTCLR.all = 0xffff;

;R1 = (sFrame.nFrame<<24)|(sFrame.nMode<<16)|(sFrame.nBits<<8)|(sFrame.nMasterEn)
;sFrame.nBitsÿֽλ
			MOV		R3,R1
			LSLS	R3,#16
			LSRS	R3,#24
			CMP		R3,#7
			BNE		SpiBit8
			B		SpiBitConfig
SpiBit8
			CMP		R3,#8
			BNE		EndSpiInit
SpiBitConfig							;pSpi->CCTL.bit.SpiLen = sFrame.nBits - 7;
			LDR		R4,[R0, #CCTL]		;R4 = pSpi->CCTL.all;
			MOVS	R5,#0x08			;R5 = 0x08
			BICS	R4,R4,R5			;R4 = R4 &(~R5)
			SUBS	R3,R3,#0x07			;R3 = R3 - 7
			LSLS	R3,R3,#0x03	  		;R3 = R3>>3
			ORRS	R4,R4,R3			;R4 = R4|R3
			STR		R4,[R0, #CCTL]		;pSpi->CCTL.all = R4;

;sFrame.nModeSPIģʽ
			MOV		R3,R1
			LSLS	R3,#8
			LSRS	R3,#24			
			CMP		R3,#0x00
			BNE		SpiMode1			;ת
			MOVS	R3,#0x01			;д
			B		SpiModeConfig		;CCTLĴ
SpiMode1	
			CMP		R3,#0x01
			BNE		SpiMode2
			MOVS	R3,#0x00
			B		SpiModeConfig
SpiMode2	
			CMP		R3,#0x02
			BNE		SpiMode3
			MOVS	R3,#0x03
			B		SpiModeConfig
SpiMode3	
			CMP		R3,#0x03
			BNE		EndSpiInit
			MOVS	R3,#0x02
SpiModeConfig							
			LDR		R4,[R0,#CCTL]		;R4 = pSpi->CCTL.all
			MOVS	R5,#0x03			;R5 = 0x03
			BICS	R4,R4,R5			;R4 = R4&(~R5)			
			ORRS	R4,R4,R3			;R4 = R4|R3
			STR		R4,[R0,#CCTL]		;pSpi->CCTL.all = R4

;sFrame.nFrameSPIλMSBLSB
			MOV		R3,R1
			LSRS	R3,#24
			CMP		R3,#0x00
			BNE		SpiLsb
			B		SpiDirectConfig
SpiLsb		CMP		R3,#0x01
			BNE		EndSpiInit
SpiDirectConfig							;pSpi->CCTL.bit.Lsbfe = sFrame.nFrame;
			LDR		R4,[R0,#CCTL]		
			MOVS	R5,#0x04
			BICS	R4,R4,R5
			LSLS	R3,R3,#0x02
			ORRS	R4,R4,R3
			STR		R4,[R0,#CCTL]

;sFrame.nMasterEnSPIģʽ
			MOV		R3,R1
			LSLS	R3,#24
			LSRS	R3,#24
			CMP		R3,#0x01
			BNE		SpiSlaveMode			
		   	STR		R2,[R0,#SPBREG]			;pSpi->SPBREG = sFrame.nSckFreqDiv
			B		SpiMasterSlaveConfig
SpiSlaveMode
			CMP		R3,#0x00
			BNE		EndSpiInit
SpiMasterSlaveConfig
			LDR		R4,[R0,#GCTL]
			MOVS	R5,#0x1C
			BICS	R4,R4,R5
			LSLS	R3,R3,#0x02				;pSpi->GCTL.bit.Mm = sFrame.nMasterEn;
			ORRS	R4,R4,R3
			MOVS	R3,#0x18	 			;pSpi->GCTL.bit.TxEn = 1;pSpi->GCTL.bit.RxEn = 1;
			ORRS	R4,R4,R3
			STR		R4,[R0,#GCTL]
			MOVS	R7,#0
EndSpiInit
			MOV		R0,R7
			POP		{R3-R7, PC}
			ENDP

ScmRegAddr		DCD		SCM_REG_BASE_ADDR
GpioRegAddr		DCD		GPIO_REG_BASE_ADDR
			
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Subroutine:	SPI_FastWrite	
; Function:		the fast optimization for SPI master write	
; Input:		UINT8 nSpiNum -- 	SPI number, SPI 0/1
; 				UINT8 *pData --		The data to be written
;				UINT32 nLen -- 		the length of data to be written										
; Output:		UINT32	--			Return the length for un-write														
; Description:	
; Date:			2014/04/15	
; ModifyRecord:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
				ALIGN
SPI_FastWrite	PROC
				EXPORT  SPI_FastWrite
				PUSH	{R3-R6, LR}

				BL		SPI_GetRegAddr

				LDR		R4, [R0, #GCTL]	; RXEN = 0
				MOV		R3, R4	; save GCTL
				MOVS	R6, #1
				LSLS	R5, R6, #RXEN	
				BICS	R4, R5
				STR		R4, [R0, #GCTL] 

				LSLS	R5, R6, #TXEPT	; mask for bit TxEpt 
SpiWrite5Byte
				CMP		R2, #4		
				BLS		SpiWriteByteReady 	; nLen<=4, go to SpiWriteByteReady
SpiWaitTxEpt
				LDR		R4, [R0, #CSTAT]
				TST		R4, R5
				BEQ		SpiWaitTxEpt 		; wait for TxEpt=1

				LDRB	R4, [R1, #0] 		; write 5 bytes to TXREG
				STR		R4, [R0, #TXREG]
				LDRB	R4, [R1, #1]
				STR		R4, [R0, #TXREG]
				LDRB	R4, [R1, #2]
				STR		R4, [R0, #TXREG]
				LDRB	R4, [R1, #3]
				STR		R4, [R0, #TXREG]
				LDRB	R4, [R1, #4]
				STR		R4, [R0, #TXREG]
				ADDS	R1, #5
				SUBS	R2, #5		
				BNE		SpiWrite5Byte
SpiWriteByteReady
				LSLS	R5, R6, #TXFULL
SpiWriteByte
				CMP		R2, #0
				BEQ		EndSpiFastWrite
SpiWaitTxFull	
			   	LDR		R4, [R0, #CSTAT]
				TST		R4, R5
				BNE		SpiWaitTxFull  	; wait for TxFull=0
				LDRB	R4, [R1]
				STR		R4, [R0, #TXREG] 	
				ADDS	R1, #1
				SUBS	R2, #1
				BNE		SpiWriteByte
EndSpiFastWrite
				LSLS	R5, R6, #TXEPT
SpiWaitTxOver
				LDR		R4, [R0, #CSTAT]
				TST		R4, R5
				BEQ		SpiWaitTxOver  	; wait for TxEpt=1

				STR		R3, [R0, #GCTL]
				MOV		R0, R2
				POP		{R3-R6, PC}
				ENDP
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Subroutine:	SPI_FastRead	
; Function:		the fast optimization for SPI master read	
; Input:		UINT8 nSpiNum -- 	SPI number, SPI 0/1
; 				UINT8 *pData --		The data to be received (pointer)
;				UINT32 nLen -- 		the length of data to be read										
; Output:		UINT32	--			Return the length for un-read														
; Description:	
; Date:			2014/04/15	
; ModifyRecord:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
				ALIGN
SPI_FastRead	PROC
				EXPORT  SPI_FastRead
				PUSH	{R3-R6, LR}
				BL		SPI_GetRegAddr

				MOVS	R6, #1
				MOVS	R3, #DUMMYS
				LSLS	R5, R6, #RXAVL
SpiRead4Byte
				CMP		R2, #4
				BCC		SpiReadByte  	; nLen<4, go to SpiReadByte
				
				STR		R3, [R0, #TXREG]  	; write dummyS byte for read
				STR		R3, [R0, #TXREG]
				STR		R3, [R0, #TXREG]
				STR		R3, [R0, #TXREG]
				SUBS	R2, #4

SpiWaitRxAvl1
				LDR		R4, [R0, #CSTAT] 	; wait for RxAvl = 1
				TST		R4, R5
				BEQ		SpiWaitRxAvl1
				LDR		R4, [R0, #RXREG] 	; read data and store
				STRB	R4, [R1]
SpiWaitRxAvl2
				LDR		R4, [R0, #CSTAT]
				TST		R4, R5
				BEQ		SpiWaitRxAvl2
				LDR		R4, [R0, #RXREG]
				STRB	R4, [R1, #1]
SpiWaitRxAvl3
				LDR		R4, [R0, #CSTAT]
				TST		R4, R5
				BEQ		SpiWaitRxAvl3
				LDR		R4, [R0, #RXREG]
				STRB	R4, [R1, #2]
SpiWaitRxAvl4
				LDR		R4, [R0, #CSTAT]
				TST		R4, R5
				BEQ		SpiWaitRxAvl4
				LDR		R4, [R0, #RXREG]
				STRB	R4, [R1, #3]

				ADDS	R1, #4
				B		SpiRead4Byte
					
SpiReadByte
				CMP		R2, #0
				BEQ		EndSpiFastRead
				STR		R3, [R0, #TXREG]
SpiWaitRxAvl
				LDR		R4, [R0, #CSTAT]
				TST		R4, R5
				BEQ		SpiWaitRxAvl
				LDR		R4, [R0, #RXREG]
				STRB	R4, [R1]
				ADDS	R1, #1
				SUBS	R2, #1
				BNE		SpiReadByte
EndSpiFastRead
				MOV		R0, R2
				POP		{R3-R6, PC}
				ENDP


 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Subroutine:	SPI_SlvFastRead	
; Function:		the fast optimization for SPI slave read	
; Input:		UINT8 nSpiNum -- 	SPI number, SPI 0/1
; 				UINT8 *pData --		The data to be received (pointer)
;				UINT32 nLen -- 		the length of data to be read										
; Output:		UINT32	--			Return the length for un-read														
; Description:	
; Date:			2014/04/15	
; ModifyRecord:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
				ALIGN
SPI_SlvFastRead	PROC
				EXPORT  SPI_SlvFastRead
				PUSH	{R3-R6, LR}
				BL		SPI_GetRegAddr
				LDR		R4, [R0, #GCTL]	; RXEN = 1
				MOV		R3, R4	; save GCTL
				MOVS	R6, #1
				LSLS	R5, R6, #RXEN	
				ORRS	R4, R5
				STR		R4, [R0, #GCTL]
				LSLS	R5, R6, #RXAVL					
SpiSlvReadByte
				CMP		R2, #0
				BEQ		EndSpiSlvFastRead
				LDR		R6, TIMEOUT
SpiSlvWaitRxAvl
				SUBS	R6, #1
				BEQ		EndSpiSlvFastRead
				LDR		R4, [R0, #CSTAT]
				TST		R4, R5
				BEQ		SpiSlvWaitRxAvl
				LDR		R4, [R0, #RXREG]
				STRB	R4, [R1]
				ADDS	R1, #1
				SUBS	R2, #1
				BNE		SpiSlvReadByte
EndSpiSlvFastRead
				STR		R3, [R0, #GCTL]
				MOV		R0, R2
				POP		{R3-R6, PC}
				ENDP
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Subroutine:	SPI_FastWrite	
; Function:		the fast optimization for SPI master write	
; Input:		UINT8 nSpiNum -- 	SPI number, SPI 0/1
; 				UINT8 *pData --		The data to be written
;				UINT32 nLen -- 		the length of data to be written										
; Output:		UINT32	--			Return the length for un-write														
; Description:	
; Date:			2014/04/15	
; ModifyRecord:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
				ALIGN
SPI_SlvFastWrite	PROC
				EXPORT  SPI_SlvFastWrite
				PUSH	{R3-R6, LR}
				BL		SPI_GetRegAddr
				LDR		R4, [R0, #GCTL]	; TXEN = 1
				MOV		R3, R4	; save GCTL
				MOVS	R6, #1
				LSLS	R5, R6, #TXEN	
				ORRS	R4, R5
				STR		R4, [R0, #GCTL] 
				LSLS	R5, R6, #TXFULL
SpiSlvWriteByte
				CMP		R2, #0
				BEQ		EndSpiSlvFastWrite
				LDR		R6, TIMEOUT
SpiSlvWaitTxFull
				SUBS	R6, #1
				BEQ		SpiSlvFastWriteTimeout	
			   	LDR		R4, [R0, #CSTAT]
				TST		R4, R5
				BNE		SpiSlvWaitTxFull  	; wait for TxFull=0
				LDRB	R4, [R1]
				STR		R4, [R0, #TXREG] 	
				ADDS	R1, #1
				SUBS	R2, #1
				BNE		SpiSlvWriteByte
EndSpiSlvFastWrite
				MOVS	R6, #1
				LSLS	R5, R6, #TXEPT
				LDR		R6, TIMEOUT
SpiSlvWaitTxOver
				SUBS	R6, #1
				BEQ		SpiSlvFastWriteTimeout
				LDR		R4, [R0, #CSTAT]
				TST		R4, R5
				BEQ		SpiSlvWaitTxOver  	; wait for TxEpt=1
SpiSlvFastWriteTimeout
				STR		R3, [R0, #GCTL]
				MOV		R0, R2
				POP		{R3-R6, PC}
				ENDP
TIMEOUT		DCD		 	2000;10000000;
				END

