#ifndef __System_H__
#define __System_H__
#include "SY09.h"
#include "algBase.h"
#include "iMD.h"



#if (INTERFACE_SEL==IMD_USE_UART)

	#define USE_UART
	#define UARTX                           UART0
	#define UARTX_MAP                       UART0_MAP_A16_A17 
  
#elif (INTERFACE_SEL==IMD_USE_I2C)
	
	#define USE_I2C		
	#define USE_I2C_A16_A17			
	#define I2CX                           	I2C0
	#define I2CX_MAP                       	I2C0_MAP_A16_A17 		
	
#else  

 #if( PLATFORM_TYPE != PLATFORM_TYPE_SIP )		
 
	#define USE_UART
	#define USE_I2C	
	#define USE_I2C_A12_A13	
		
	#define UARTX                           UART0
	#define UARTX_MAP                       UART0_MAP_A16_A17 
	
	#define I2CX                           	I2C0
	#define I2CX_MAP                       	I2C0_MAP_A12_A13 
	
 #else 
	
	#define USE_UART
	#define UARTX                           UART0
	#define UARTX_MAP                       UART0_MAP_A16_A17 
     	
 #endif
	
#endif

#define AUTO_CMD 	
//****************************************************************************
//******************************Flash Config**********************************
//****************************************************************************
/*
| ݿ 
|____________       
|
|  ȫ洢    
|____________      
|
|      
|____________ 
*/
//ע CODE_BLOCK+ SFLASH_BLOCK+ OPEN_FLASH_BLOCK< FLASH_SPEC_BLOCK
#define	FLASH_SPEC                          0x80000                               //Flash С512K
#define	FLASH_BYTE_BLOCK                    512                                   //Flash С512 
#define	FLASH_SPEC_BLOCK                    (FLASH_SPEC/FLASH_BYTE_BLOCK)
#define	CODE_BLOCK                          630                                   //ռ630飬ÿ512ֽڣ˿ռҪmapдռһ 

#if (SENSOR_CHOICE == FP300)
//	#define	SFLASH_BLOCK                    306                                   //ȫ洢ռ306飬ÿ512ֽ 
//	#define	OPEN_FLASH_BLOCK                300                                   //ȫ洢ռ300飬ÿ512ֽ 
//#else
	#define	SFLASH_BLOCK                    200                                   //ȫ洢ռ200飬ÿ512ֽ 
	#define	OPEN_FLASH_BLOCK                194                                   //ȫ洢ռ194飬ÿ512ֽ 
#endif
//******************************ȫ洢ռ**********************************
/*
addr
|______________________      
|
| ָģ    
|______________________
|   
| ָ
|______________________   
|   
| Ŵز 
|______________________       
|
| ־    
|______________________      
|
| ϵͳ    
|______________________Сַ 
*/
// SFLASHĻ 
#define SFLASH_PAGE_SIZE                	512     							//ÿҳ512ֽ
#define SFLASH_BLOCK_SIZE               	512    								//ÿ512ֽ
#define SFLASH_PAGE_NUM                		(SFLASH_BLOCK* SFLASH_BLOCK_SIZE/SFLASH_PAGE_SIZE)   //ȫ洢ʵʴ洢ռ䣬λҳ 
// ϵͳ С1ҳ(512ֽ)  	1ҳ(512ֽ) 
#define	PARA_TAB_PAGE                   	0       							//ŲʼҳС1ҳ  512ֽڣ
#define	PARA_TAB_PAGE_N                 	1      								//С 
#define	PARA_TAB_RVS                 		(PARA_TAB_PAGE+PARA_TAB_PAGE_N)     //Ųռʼַ
#define	PARA_TAB_RVS_N                  	1     								//С 
#define WLENOFPARATAB                   	64      							//Уϵͳ
// ־ С1ҳ(512ֽ)  		1ҳ(512ֽ) 
#define NOTEPAD_PAGE                    	(PARA_TAB_RVS+PARA_TAB_RVS_N)       //־ҳ 
#define NOTEPAD_PAGE_N                  	1
#define NOTEPAD_RVS_PAGE                    (NOTEPAD_PAGE+NOTEPAD_PAGE_N)   	//־ҳ  
#define NOTEPAD_RVS_N                   	0
// Ŵ С1ҳ(512ֽ)  1ҳ(512ֽ) 
#define PARA_SENSOR_PAGE            		(NOTEPAD_RVS_PAGE+NOTEPAD_RVS_N)   
#define PARA_SENSOR_PAGE_N          		1
#define PARA_SENSOR_RVS            			(PARA_SENSOR_PAGE+PARA_SENSOR_PAGE_N)   
#define PARA_SENSOR_RVS_N          			1

//*********************************ָز***************************************
#define FP_START_ADDR     					(PARA_SENSOR_RVS+PARA_SENSOR_RVS_N) 
//  С2ҳ(512ֽ)  	6ҳ(512ֽ) 
#define MB_INDEX_PAGE                   	(FP_START_ADDR)        
#define MB_INDEX_PAGE_N                 	1									//С2ҳ512*2öָ 
#define MB_INDEX_RVS                    	(MB_INDEX_PAGE+MB_INDEX_PAGE_N)  
#define MB_INDEX_RVS_N                  	0									//С6ҳ512*6öָ 

//ģŵʼַ    
#define START_MB_PAGE             			(MB_INDEX_RVS+MB_INDEX_RVS_N)     	//ģҳ 

#if (SENSOR_CHOICE == FP300)

	#define PER_MB_USER              		(1)
	#define FP_PER_USER              		(ALG_TZ_MB*PER_MB_USER)
	#define Enroll_MB_USER           		 FP_PER_USER
    
#endif

/* FP_CAPACITY = 195(remain pages) * 512(bytes) / 768(perMB) = 130 MBs  --> 43 index */
#if (SENSOR_CHOICE == FP300)
	#define FP_CAPACITY              		(100)                    			//ָ,㷨ÿ768ֽڣ㷨ÿ512ֽ
#endif

#define USER_NUM                 			(FP_CAPACITY/PER_MB_USER)   		//û=ָ/ÿûָ  
#define USER_PF_SPEC             			(PER_MB_USER * ALG_SIZEOFMB)        //ģС, ALG_SIZEOFTZο㷨ļ algBase.h 

//*********************************Comm buff *************************************
#if (SENSOR_CHOICE == FP300)
	#define IMG_BUF                         (0x20000000)               			//ͼַ_㷨ʹõͼַΪ  

#endif

#define TEMP_BUFC                       	(0x2001F000)               			//ʱʹþԵַ_(USB/UART)תϴ
#define NormalInsBuf                    	((UINT8 *)TEMP_BUFC)
#define UART_BUF							((UINT8 *)TEMP_BUFC)
#define BigDataBuf                      	((UINT8 *)IMG_BUF)
//********************************Reback Val************************************
#define NO_DETECT_FINGER		            0x02                                    //ָ 
//**********************************Other***************************************
#define ST_NULL		                        0
#define ST_UPIMAGE	                        0x01
#define ST_UPCHAR	                        0x02
#define ST_DOWNIMAGE	                    0x03
#define	ST_DOWNCHAR		                    0x04
#define	ST_BURNCODE		                    0x05

#define NOTEPAD_MAX_PAGEID                  15
#define	write_mreg( mreg, val)	            *(volatile unsigned int *)(mreg) = (val); 
#define	read_mreg( mreg, val)	            (val) = *(volatile unsigned int *)(mreg);
#define	BW(H,L,W)					        W = ((H << 8) & 0xff00)	|(L & 0xff)

typedef struct _StruMBFile
{
    UINT8 cCharFile[FP_PER_USER][ALG_SIZE_TZ];
}StruMBFile;

	
typedef struct _SYNOC_SPARATAB
{
	UINT16 SSR;
	UINT16 SenType;
	UINT16 DataSize;
	UINT16 SecurLevel;
	UINT16 DeviceAddr[2];	
	UINT16 CFG_PktSize;
	UINT16 CFG_BaudRate;
	UINT16 CFG_VID;
	UINT16 CFG_PID;
	UINT16 Reserved_a[4];
	UINT16 ProductSN[4];
	UINT16 SWVersion[4];
	UINT16 ManuFacture[4];
	UINT16 SensorName[4];
	UINT16 PassWord[2];
	UINT16 JTAGLockFlg[2];
	UINT16 SensorInitEntry;
	UINT16 SensorGetImageEntry;
	UINT16 Reserved_b[26];
	UINT16 ParaBcc;
	UINT16 ParaTabFlg;
} SYNOC_SPARATAB,*SYNOC_PSPARATAB;

/***************************************************************************************************
** Global Variable Declaration
***************************************************************************************************/
extern UINT8 gcpUserIndex[];	   //gcpUserIndex[1]==1ʾ ID=1û,IDſԴλ
extern StruMBFile gsCharBuffer1,gsCharBuffer2;
//extern StruMBFile gsCharBuffer[];
extern SYNOC_SPARATAB gParaTab;
extern UINT16 gwPktSize;
extern UINT32 glPassWord;
extern UINT16 giMBCounter;
extern UINT16 gwMatchScore;                 

/***************************************************************************************************
** Global Functon 
***************************************************************************************************/
UINT8 ReadFlash(UINT8* pDataBuf,UINT32 nOffset,UINT16 nDataNum);
UINT8 WriteFlash(UINT8* pDataBuf,UINT32 nOffset,UINT16 nDataNum);

UINT16 ParaGenBCC(UINT16 *wpParaBuf);
UINT8 ReadParaTab(void);
UINT8 WriteParaTab(void);
extern void InitDeviceInfo(void);

UINT16 UserStatistics(void);    //ͳû
UINT8 ReadSysPapaImfo(UINT8 *pDat);//ȡϢ
UINT8 ReadNoteData(UINT8 *pDat,UINT16 nLen)	;//־ 
UINT8 WriteNoteData(UINT8 *pDat,UINT16 nLen);//д־  
UINT8 WriteNoteDataPage(UINT8 *pDat,UINT16 offSet,UINT16 nLen);//־ 
UINT8 ReadNoteDataPage(UINT8 *pDat,UINT16 offSet,UINT16 nLen);//д־
UINT8 ClearSysInitFlag(void);
UINT8 SetSysInitFlag(void);
UINT8 CheckSysInitFlag(void);
UINT8 GetFreeUesrId(UINT16 *pUserId);//ȡID 
UINT8 checkVaildUserId(UINT16 wUserId);//ûIDǷЧ  
UINT8 SaveUserFp(StruMBFile *p,UINT16 wUserId);//ûģ
UINT8 AddUserFpMb(UINT8 *pDat,UINT16 wUserId);//ûMB  
UINT8 GetUserFp(StruMBFile *p,UINT16 wUserId);//ȡûģ 
UINT8 DeteleUser(UINT16 wUserId,UINT16 nNum); //ɾָû 
UINT8 DeteleUserAll(void);  //ɾû  
UINT16 FPMBIndexToUserID(UINT16 wIndex);//ģתID
UINT16 UserIDToFPMBIndex(UINT16 wUserId);//IDתģ
UINT8 JudgeEnrollPara(UINT16 JuIDtemp, UINT8 JuGetMBNum, UINT8 JuStoreMode);//CmdAutoEnrollյĲǷȷ
UINT8 JudgeIdentifyPara(UINT8 JuSecurityLV, UINT16 JuIDtemp);//CmdAutoIdentifyյĲǷȷ

//ģز 
void ClearFPMBIndexAll(void); //ģ 
UINT8 ClearFPMBIndexN(UINT16 wIndex,UINT16 num); //ָģ
UINT8 SetFPMBIndexOne(UINT16 wIndex); //ģЧ 
UINT8 SetFPMBIndexN(UINT16 wSIndex,UINT16 IndexNum); 
void GetFPMBIndex(void);//flashģ 
void SaveFPMBIndex(void);//ģ 
UINT8 CheckVaildFPMBIndex(UINT16 wIndex);//ָģǷЧ
UINT8 UserMbMergeFeature(UINT8 *pChar,UINT16 wUserId,UINT16 MbIndex,UINT8 MergeAll); 
//ģز
/*ģҳ*/
UINT8 ReadFpMB(unsigned char* pMBBuf,UINT16 Index);//ָģ壬Ӧģ 
/*дģҳ*/
UINT8 WriteFpMB(unsigned char* pMBBuf,UINT16 Index);//дָģ壬Ӧģ
/*ģҳ*/
UINT8 ReadFpMB_N(unsigned char* pMBBuf,UINT16 Index,UINT8 num);//ָģ壬Ӧģ
/*дģҳ*/
UINT8 WriteFpMB_N(unsigned char* pMBBuf,UINT16 Index,UINT8 num);//дָģ壬Ӧģ
#endif

     	





