/* iMD Global Config */

#ifndef _IMD_h_
#define _IMD_h_

//***************************************************************************
// user configuration
#define FW_VERSION      "2.3.4.14"  	//8 bytes

   
#define MODULE_HF302_GD	1     
#define MODULE_SEL     MODULE_HF302_GD



#define PLATFORM_TYPE_SIP                       1
#define PLATFORM_TYPE_CSP_AS608_MODULE_BOARD    2
#define PLATFORM_TYPE_QFN_AS608_DEV_BOARD       3 
#define PLATFORM_TYPE   						PLATFORM_TYPE_QFN_AS608_DEV_BOARD

#define VIDPID_IMD      1
#define VIDPID_SYNO     2
#define VIDPID_SEL      VIDPID_IMD

//****************************************************************************
//If want to use ICE(ULINK2) debug on IMD_AS608_REV_A_DEV_BOARD, set to 1 or set to 0.

#define IG101_SLEEP_MODE			0		// 
#define JudgeImage					1		// 1: run judge by JudgeImage_klz , 0: run judge by kpi_get_touch_area
#define IMD_ICE_DEBUG   			0
#define DEBUGPRINTF 				0       // dump debug information
#define BAUDRATE					6		// 9600*6=57600
#define SECURE_LEVEL				3		//
#define _RTT_PRINTF_                0
#define IMAGEPROCESS                1
#define IMAGE_BINARY                0
#define IMAGE_FLIP_H                0


/***************************************************************************
InterFace Selction
2018/6/8
****************************************************************************

IMD_USE_USB 		: 	Always Enable   

IMD_USE_UART		:	UART0
						MAP_A16,A17 

IMD_USE_I2C			:	I2C0
						MAP_A16,A17

IMD_USE_UART_I2C	:	UART0
						MAP_A16,A17 
			
						I2C0
						MAP_A12,A13
***************************************************************************/


#define USE_USB    		
#define IMD_USE_UART    	1
#define IMD_USE_I2C    		2
#define IMD_USE_UART_I2C    3

#define INTERFACE_SEL		IMD_USE_UART


//***************************************************************************


// Product VID/PID define
#if     VIDPID_SEL == VIDPID_IMD
    #define USB_VID 			0x2B41
    #define USB_PID 			0x0101
    #define DEVICE_DES_VENDOR   "iMD\0\0\0\0\0"			//8  bytes
    #define DEVICE_DES_PRODUCT  "Finger Module\0\0\0"	//16 bytes
	#define PRUDUCT_SN			"No.00001"				//8  bytes
	#define MANU_FACTURE		"iMD SY09"				//8  bytes
    
#elif   VIDPID_SEL == VIDPID_SYNO
    #define USB_VID 			0x2109
    #define USB_PID 			0x7638  
    #define DEVICE_DES_VENDOR   "Syno\0\0\0\0"
    #define DEVICE_DES_PRODUCT  "Finger Module\0\0\0"
	#define PRUDUCT_SN			"  Demo  "
	#define MANU_FACTURE		"iMD SY09"
#endif

//***************************************************************************
// Chip Type
// Select iMD FP Sensors

#define FP300	1


#if     MODULE_SEL == MODULE_HF302_GD
    
        #define SENSOR_CHOICE   FP300
	    #define SENSOR_NAME		"HF302GD \0"	//8 bytes  
	
#endif    

#define	IMD_AS608_REV_A_DEV_BOARD	(PLATFORM_TYPE != PLATFORM_TYPE_SIP)




//IMPORTANT NOTE: The value "a" must be INT type in the following marco.
#define DCOFFSET_INT2REG(a)	(a>0? a : abs(a)|0x80)
#define DCOFFSET_REG2INT(a)	((a&0x80)>0? -(a&0x7F) : a)
#define DCOFFSET_RANGECHK(a) (a>0? (a>0x7F?a=0x7F:a) : (abs(a)>0x7F?a=-0x7F:a))

//***************************************************************************
#if( PLATFORM_TYPE == PLATFORM_TYPE_SIP )
	#define	FPC_CSUSE		GpioRegs.GPBUSE1.bit.GPB8
	#define	FPC_CSDATA		GpioRegs.GPBDATA.bit.GPB8
	#define	FPC_RSTUSE		GpioRegs.GPBUSE0.bit.GPB7
	#define	FPC_RSTDATA		GpioRegs.GPBDATA.bit.GPB7
	#define	INT_USE			GpioRegs.GPBUSE0.bit.GPB1
	#define	INT_CLR			GpioRegs.GPBINT.bit.GPB1
	#define	INT_DATA		GpioRegs.GPBDATA.bit.GPB1

	#define	FPC_SPIx		SPI1
#endif 

#if( PLATFORM_TYPE == PLATFORM_TYPE_CSP_AS608_MODULE_BOARD )
	#define	FPC_CSUSE    	GpioRegs.GPBUSE0.bit.GPB5
	#define	FPC_CSDATA   	GpioRegs.GPBDATA.bit.GPB5
	#define	FPC_RSTUSE   	GpioRegs.GPBUSE0.bit.GPB0
	#define	FPC_RSTDATA  	GpioRegs.GPBDATA.bit.GPB0   
	#define	INT_USE   		GpioRegs.GPBUSE0.bit.GPB1
	#define	INT_CLR   		GpioRegs.GPBINT.bit.GPB1
	#define	INT_DATA   		GpioRegs.GPBDATA.bit.GPB1

	#define	FPC_SPIx   		SPI1	

#if( 1 == IMD_ICE_DEBUG )
	#define DEV_GLED_INIT			
	#define DEV_GLED_ON				
	#define DEV_RLED_INIT			
	#define DEV_RLED_OFF			
#else
    
#endif 

#endif 

#if( PLATFORM_TYPE == PLATFORM_TYPE_QFN_AS608_DEV_BOARD )
	#define FPC_CSUSE       GpioRegs.GPAUSE0.bit.GPA0	
	#define FPC_CSDATA      GpioRegs.GPADATA.bit.GPA0
	#define FPC_RSTUSE      GpioRegs.GPAUSE0.bit.GPA1	
	#define FPC_RSTDATA     GpioRegs.GPADATA.bit.GPA1 

	#define INT_USE         GpioRegs.GPAUSE0.bit.GPA3		//sensor analog Int 
	#define INT_CLR   		GpioRegs.GPAINT.bit.GPA3
	#define INT_DATA   		GpioRegs.GPADATA.bit.GPA3
    
    
    #define EN_USE          GpioRegs.GPAUSE0.bit.GPA2		//IG102 LDO enable  Hi:enable 
	//#define EN_CLR   		GpioRegs.GPAINT.bit.GPA2
	#define EN_DATA   		GpioRegs.GPADATA.bit.GPA2
    

	#define FPC_SPIx        SPI0

#if( 1 == IMD_ICE_DEBUG )
/*
	#define DEV_GLED_INIT			
	#define DEV_GLED_ON				
	#define DEV_RLED_INIT			
	#define DEV_RLED_OFF	
*/    
#else
	#define DEV_GLED_INIT	GpioRegs.GPAUSE1.bit.GPA9 = OUTPUT;
	#define DEV_GLED_ON		GpioRegs.GPADATA.bit.GPA9 = 1;
	#define DEV_RLED_INIT	GpioRegs.GPAUSE1.bit.GPA8 = OUTPUT;
	#define DEV_RLED_OFF	GpioRegs.GPADATA.bit.GPA8 = 0;
    
#endif 

#ifdef DEBUGPRINTF

	#define OUTPUT_DEBUG_STRING(fmt, ...)	\
		printf("\r\n" fmt, ##__VA_ARGS__)
	#define ENTER \
		OUTPUT_DEBUG_STRING("-> %s()", __FUNCTION__)			
#endif


#endif 

#endif
