
/****************************************************************************
* File name    :	main.c
* Function     :	the main application of the testing
* Author       : 	footman
* Date         :	2015/07/1
* Version      :    v1.0
* Description  :
* ModifyRecord :
****************************************************************************/

/**********************************************************************************
* Include Header Files
**********************************************************************************/
#include "SYglobal.h"

/**********************************************************************************
* Local Macro Definition
**********************************************************************************/


/**********************************************************************************
* Local Type Definition
**********************************************************************************/


/**********************************************************************************
* Global Variable Declaration
**********************************************************************************/
#if IMD_LOWPOWER_ENHANCE==1
extern bool gFinger_MB_F;
#endif
#ifdef IMD_SPT_CARD_DEMO
extern UINT8 VBUS_Enable;
extern UINT8 oldVBUS_Enable;
#endif

BOOL g_bSensorInit=FALSE;

static volatile unsigned long long ticks=0;
/**********************************************************************************
* Local Functon Declaration
**********************************************************************************/


/**********************************************************************************
* Functon
**********************************************************************************/

//**********************************************************************************/
/*----------------------------------------------------------------------------
  SysTick IRQ: Executed periodically
 *----------------------------------------------------------------------------*/
void SysTick_Handler (void) 		/* SysTick Interrupt Handler (10ms)   */
{           
	ticks++; 				/* Set Clock1s to 1 every 1 second    */
}

unsigned long long  GetSysTick (void) 		/* Get System Tick (10ms)   */
{           
	return ticks; 				/* Set Clock1s to 1 every 1 second    */
}

extern  void FP_SleepMode(U8 a_OnOff);


/****************************************************************************
 * Subroutine:	main
 * Function:	the main function
 * Input:		None
 * Output:		
 * Description:	 
 * Date:		2015/07/1
 * ModifyRecord:
 * *************************************************************************/ 

UINT8 FPXGetImage(bool mode);
int main()
{
 	UINT16 StartPage = 576,EndPage = 320;
 	EfcRegs.DATAPRO = FLASH_BASE_ADDR + StartPage * FLASH_PAGE_SIZE;	
	SF_Init(StartPage, StartPage + EndPage);
	SensorPortInitial();

    SCM_SetSysClk(SYS_CLK_144M);    
	InitDeviceInfo();
    
    EN_USE=OUTPUT;
    EN_DATA=1;	 
    
	SCM_EnableModClk(ID_FPA);
	SCM_ReleaseModRst(ID_FPA);  

    if(RT_OK == InitSensor()) 	       //   Sensor init 
       g_bSensorInit = TRUE;
     
     
#ifdef TRIM_UART
	Switch_72M();
#endif     
    
	ProtocolInit();				
	SCM_AnModPowerDisable(AN_TRNG_RING);	
	SCM_DisableModClk(ID_TRNG);			
	SCM_KeepModRst(ID_TRNG);	  	
	 NVIC_SetPriority(USB_IRQn,  6U);					
	
	__enable_irq();
	
    FPXGetImage(0);	 // Capture Image. 

while( 1 )
  {	 
     Get_Pkg();
	 DoCommPkg();

  } 
 
 
}






